/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.App;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.services.opsworks.model.EnvironmentVariable;
import com.amazonaws.services.opsworks.model.transform.DataSourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.EnvironmentVariableJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SslConfigurationJsonMarshaller;
import java.util.Map;

public class AppJsonMarshaller {
    private static AppJsonMarshaller instance;

    public void marshall(App app, StructuredJsonGenerator jsonGenerator) {
        if (app == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList environmentList;
            SdkInternalMap attributesMap;
            SdkInternalList domainsList;
            SdkInternalList dataSourcesList;
            jsonGenerator.writeStartObject();
            if (app.getAppId() != null) {
                jsonGenerator.writeFieldName("AppId").writeValue(app.getAppId());
            }
            if (app.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(app.getStackId());
            }
            if (app.getShortname() != null) {
                jsonGenerator.writeFieldName("Shortname").writeValue(app.getShortname());
            }
            if (app.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(app.getName());
            }
            if (app.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(app.getDescription());
            }
            if (!(dataSourcesList = (SdkInternalList)app.getDataSources()).isEmpty() || !dataSourcesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DataSources");
                jsonGenerator.writeStartArray();
                for (Object dataSourcesListValue : dataSourcesList) {
                    if (dataSourcesListValue == null) continue;
                    DataSourceJsonMarshaller.getInstance().marshall((DataSource)dataSourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (app.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(app.getType());
            }
            if (app.getAppSource() != null) {
                jsonGenerator.writeFieldName("AppSource");
                SourceJsonMarshaller.getInstance().marshall(app.getAppSource(), jsonGenerator);
            }
            if (!(domainsList = (SdkInternalList)app.getDomains()).isEmpty() || !domainsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Domains");
                jsonGenerator.writeStartArray();
                for (Object domainsListValue : domainsList) {
                    if (domainsListValue == null) continue;
                    jsonGenerator.writeValue((String)domainsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (app.getEnableSsl() != null) {
                jsonGenerator.writeFieldName("EnableSsl").writeValue(app.getEnableSsl());
            }
            if (app.getSslConfiguration() != null) {
                jsonGenerator.writeFieldName("SslConfiguration");
                SslConfigurationJsonMarshaller.getInstance().marshall(app.getSslConfiguration(), jsonGenerator);
            }
            if (!(attributesMap = (SdkInternalMap)app.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : attributesMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeValue((String)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (app.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(app.getCreatedAt());
            }
            if (!(environmentList = (SdkInternalList)app.getEnvironment()).isEmpty() || !environmentList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Environment");
                jsonGenerator.writeStartArray();
                for (EnvironmentVariable environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    EnvironmentVariableJsonMarshaller.getInstance().marshall(environmentListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AppJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AppJsonMarshaller();
        }
        return instance;
    }
}

