/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyVpcEndpointRequestMarshaller
implements Marshaller<Request<ModifyVpcEndpointRequest>, ModifyVpcEndpointRequest> {
    @Override
    public Request<ModifyVpcEndpointRequest> marshall(ModifyVpcEndpointRequest modifyVpcEndpointRequest) {
        SdkInternalList removeRouteTableIdsList;
        SdkInternalList addRouteTableIdsList;
        if (modifyVpcEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyVpcEndpointRequest> request = new DefaultRequest<ModifyVpcEndpointRequest>(modifyVpcEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcEndpoint");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcEndpointRequest.getVpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringUtils.fromString(modifyVpcEndpointRequest.getVpcEndpointId()));
        }
        if (modifyVpcEndpointRequest.getResetPolicy() != null) {
            request.addParameter("ResetPolicy", StringUtils.fromBoolean(modifyVpcEndpointRequest.getResetPolicy()));
        }
        if (modifyVpcEndpointRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(modifyVpcEndpointRequest.getPolicyDocument()));
        }
        if (!(addRouteTableIdsList = (SdkInternalList)modifyVpcEndpointRequest.getAddRouteTableIds()).isEmpty() || !addRouteTableIdsList.isAutoConstruct()) {
            int addRouteTableIdsListIndex = 1;
            for (String addRouteTableIdsListValue : addRouteTableIdsList) {
                if (addRouteTableIdsListValue != null) {
                    request.addParameter("AddRouteTableId." + addRouteTableIdsListIndex, StringUtils.fromString(addRouteTableIdsListValue));
                }
                ++addRouteTableIdsListIndex;
            }
        }
        if (!(removeRouteTableIdsList = (SdkInternalList)modifyVpcEndpointRequest.getRemoveRouteTableIds()).isEmpty() || !removeRouteTableIdsList.isAutoConstruct()) {
            int removeRouteTableIdsListIndex = 1;
            for (String removeRouteTableIdsListValue : removeRouteTableIdsList) {
                if (removeRouteTableIdsListValue != null) {
                    request.addParameter("RemoveRouteTableId." + removeRouteTableIdsListIndex, StringUtils.fromString(removeRouteTableIdsListValue));
                }
                ++removeRouteTableIdsListIndex;
            }
        }
        return request;
    }
}

