/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.NetworkAclAssociation;
import com.amazonaws.services.ec2.model.NetworkAclEntry;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class NetworkAcl
implements Serializable,
Cloneable {
    private String networkAclId;
    private String vpcId;
    private Boolean isDefault;
    private SdkInternalList<NetworkAclEntry> entries;
    private SdkInternalList<NetworkAclAssociation> associations;
    private SdkInternalList<Tag> tags;

    public void setNetworkAclId(String networkAclId) {
        this.networkAclId = networkAclId;
    }

    public String getNetworkAclId() {
        return this.networkAclId;
    }

    public NetworkAcl withNetworkAclId(String networkAclId) {
        this.setNetworkAclId(networkAclId);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public NetworkAcl withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public NetworkAcl withIsDefault(Boolean isDefault) {
        this.setIsDefault(isDefault);
        return this;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public List<NetworkAclEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new SdkInternalList();
        }
        return this.entries;
    }

    public void setEntries(Collection<NetworkAclEntry> entries) {
        if (entries == null) {
            this.entries = null;
            return;
        }
        this.entries = new SdkInternalList<NetworkAclEntry>(entries);
    }

    public NetworkAcl withEntries(NetworkAclEntry ... entries) {
        if (this.entries == null) {
            this.setEntries(new SdkInternalList<NetworkAclEntry>(entries.length));
        }
        for (NetworkAclEntry ele : entries) {
            this.entries.add(ele);
        }
        return this;
    }

    public NetworkAcl withEntries(Collection<NetworkAclEntry> entries) {
        this.setEntries(entries);
        return this;
    }

    public List<NetworkAclAssociation> getAssociations() {
        if (this.associations == null) {
            this.associations = new SdkInternalList();
        }
        return this.associations;
    }

    public void setAssociations(Collection<NetworkAclAssociation> associations) {
        if (associations == null) {
            this.associations = null;
            return;
        }
        this.associations = new SdkInternalList<NetworkAclAssociation>(associations);
    }

    public NetworkAcl withAssociations(NetworkAclAssociation ... associations) {
        if (this.associations == null) {
            this.setAssociations(new SdkInternalList<NetworkAclAssociation>(associations.length));
        }
        for (NetworkAclAssociation ele : associations) {
            this.associations.add(ele);
        }
        return this;
    }

    public NetworkAcl withAssociations(Collection<NetworkAclAssociation> associations) {
        this.setAssociations(associations);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public NetworkAcl withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public NetworkAcl withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkAclId() != null) {
            sb.append("NetworkAclId: ").append(this.getNetworkAclId()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getIsDefault() != null) {
            sb.append("IsDefault: ").append(this.getIsDefault()).append(",");
        }
        if (this.getEntries() != null) {
            sb.append("Entries: ").append(this.getEntries()).append(",");
        }
        if (this.getAssociations() != null) {
            sb.append("Associations: ").append(this.getAssociations()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAcl)) {
            return false;
        }
        NetworkAcl other = (NetworkAcl)obj;
        if (other.getNetworkAclId() == null ^ this.getNetworkAclId() == null) {
            return false;
        }
        if (other.getNetworkAclId() != null && !other.getNetworkAclId().equals(this.getNetworkAclId())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getIsDefault() == null ^ this.getIsDefault() == null) {
            return false;
        }
        if (other.getIsDefault() != null && !other.getIsDefault().equals(this.getIsDefault())) {
            return false;
        }
        if (other.getEntries() == null ^ this.getEntries() == null) {
            return false;
        }
        if (other.getEntries() != null && !other.getEntries().equals(this.getEntries())) {
            return false;
        }
        if (other.getAssociations() == null ^ this.getAssociations() == null) {
            return false;
        }
        if (other.getAssociations() != null && !other.getAssociations().equals(this.getAssociations())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkAclId() == null ? 0 : this.getNetworkAclId().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getIsDefault() == null ? 0 : this.getIsDefault().hashCode());
        hashCode = 31 * hashCode + (this.getEntries() == null ? 0 : this.getEntries().hashCode());
        hashCode = 31 * hashCode + (this.getAssociations() == null ? 0 : this.getAssociations().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public NetworkAcl clone() {
        try {
            return (NetworkAcl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

