/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidentity.model.RoleMapping;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SetIdentityPoolRolesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String identityPoolId;
    private Map<String, String> roles;
    private Map<String, RoleMapping> roleMappings;

    public void setIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
    }

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public SetIdentityPoolRolesRequest withIdentityPoolId(String identityPoolId) {
        this.setIdentityPoolId(identityPoolId);
        return this;
    }

    public Map<String, String> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<String, String> roles) {
        this.roles = roles;
    }

    public SetIdentityPoolRolesRequest withRoles(Map<String, String> roles) {
        this.setRoles(roles);
        return this;
    }

    public SetIdentityPoolRolesRequest addRolesEntry(String key, String value) {
        if (null == this.roles) {
            this.roles = new HashMap<String, String>();
        }
        if (this.roles.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.roles.put(key, value);
        return this;
    }

    public SetIdentityPoolRolesRequest clearRolesEntries() {
        this.roles = null;
        return this;
    }

    public Map<String, RoleMapping> getRoleMappings() {
        return this.roleMappings;
    }

    public void setRoleMappings(Map<String, RoleMapping> roleMappings) {
        this.roleMappings = roleMappings;
    }

    public SetIdentityPoolRolesRequest withRoleMappings(Map<String, RoleMapping> roleMappings) {
        this.setRoleMappings(roleMappings);
        return this;
    }

    public SetIdentityPoolRolesRequest addRoleMappingsEntry(String key, RoleMapping value) {
        if (null == this.roleMappings) {
            this.roleMappings = new HashMap<String, RoleMapping>();
        }
        if (this.roleMappings.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.roleMappings.put(key, value);
        return this;
    }

    public SetIdentityPoolRolesRequest clearRoleMappingsEntries() {
        this.roleMappings = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.getIdentityPoolId()).append(",");
        }
        if (this.getRoles() != null) {
            sb.append("Roles: ").append(this.getRoles()).append(",");
        }
        if (this.getRoleMappings() != null) {
            sb.append("RoleMappings: ").append(this.getRoleMappings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityPoolRolesRequest)) {
            return false;
        }
        SetIdentityPoolRolesRequest other = (SetIdentityPoolRolesRequest)obj;
        if (other.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (other.getIdentityPoolId() != null && !other.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (other.getRoles() == null ^ this.getRoles() == null) {
            return false;
        }
        if (other.getRoles() != null && !other.getRoles().equals(this.getRoles())) {
            return false;
        }
        if (other.getRoleMappings() == null ^ this.getRoleMappings() == null) {
            return false;
        }
        return other.getRoleMappings() == null || other.getRoleMappings().equals(this.getRoleMappings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getRoles() == null ? 0 : this.getRoles().hashCode());
        hashCode = 31 * hashCode + (this.getRoleMappings() == null ? 0 : this.getRoleMappings().hashCode());
        return hashCode;
    }

    @Override
    public SetIdentityPoolRolesRequest clone() {
        return (SetIdentityPoolRolesRequest)super.clone();
    }
}

