/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cognitosync.AmazonCognitoSync;
import com.amazonaws.services.cognitosync.AmazonCognitoSyncClientBuilder;
import com.amazonaws.services.cognitosync.model.AlreadyStreamedException;
import com.amazonaws.services.cognitosync.model.AmazonCognitoSyncException;
import com.amazonaws.services.cognitosync.model.BulkPublishRequest;
import com.amazonaws.services.cognitosync.model.BulkPublishResult;
import com.amazonaws.services.cognitosync.model.ConcurrentModificationException;
import com.amazonaws.services.cognitosync.model.DeleteDatasetRequest;
import com.amazonaws.services.cognitosync.model.DeleteDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.services.cognitosync.model.DescribeDatasetResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageRequest;
import com.amazonaws.services.cognitosync.model.DescribeIdentityUsageResult;
import com.amazonaws.services.cognitosync.model.DuplicateRequestException;
import com.amazonaws.services.cognitosync.model.GetBulkPublishDetailsRequest;
import com.amazonaws.services.cognitosync.model.GetBulkPublishDetailsResult;
import com.amazonaws.services.cognitosync.model.GetCognitoEventsRequest;
import com.amazonaws.services.cognitosync.model.GetCognitoEventsResult;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.GetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.InternalErrorException;
import com.amazonaws.services.cognitosync.model.InvalidConfigurationException;
import com.amazonaws.services.cognitosync.model.InvalidLambdaFunctionOutputException;
import com.amazonaws.services.cognitosync.model.InvalidParameterException;
import com.amazonaws.services.cognitosync.model.LambdaThrottledException;
import com.amazonaws.services.cognitosync.model.LimitExceededException;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.services.cognitosync.model.ListDatasetsResult;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageRequest;
import com.amazonaws.services.cognitosync.model.ListIdentityPoolUsageResult;
import com.amazonaws.services.cognitosync.model.ListRecordsRequest;
import com.amazonaws.services.cognitosync.model.ListRecordsResult;
import com.amazonaws.services.cognitosync.model.NotAuthorizedException;
import com.amazonaws.services.cognitosync.model.RegisterDeviceRequest;
import com.amazonaws.services.cognitosync.model.RegisterDeviceResult;
import com.amazonaws.services.cognitosync.model.ResourceConflictException;
import com.amazonaws.services.cognitosync.model.ResourceNotFoundException;
import com.amazonaws.services.cognitosync.model.SetCognitoEventsRequest;
import com.amazonaws.services.cognitosync.model.SetCognitoEventsResult;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import com.amazonaws.services.cognitosync.model.SetIdentityPoolConfigurationResult;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetRequest;
import com.amazonaws.services.cognitosync.model.SubscribeToDatasetResult;
import com.amazonaws.services.cognitosync.model.TooManyRequestsException;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import com.amazonaws.services.cognitosync.model.UnsubscribeFromDatasetResult;
import com.amazonaws.services.cognitosync.model.UpdateRecordsRequest;
import com.amazonaws.services.cognitosync.model.UpdateRecordsResult;
import com.amazonaws.services.cognitosync.model.transform.BulkPublishRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.BulkPublishResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DeleteDatasetRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DeleteDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeDatasetRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityPoolUsageRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityPoolUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityUsageRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.DescribeIdentityUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.GetBulkPublishDetailsRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.GetBulkPublishDetailsResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.GetCognitoEventsRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.GetCognitoEventsResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.GetIdentityPoolConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.GetIdentityPoolConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListDatasetsRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListDatasetsResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListIdentityPoolUsageRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListIdentityPoolUsageResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListRecordsRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.ListRecordsResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.RegisterDeviceRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.RegisterDeviceResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.SetCognitoEventsRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.SetCognitoEventsResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.SetIdentityPoolConfigurationRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.SetIdentityPoolConfigurationResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.SubscribeToDatasetRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.SubscribeToDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.UnsubscribeFromDatasetRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.UnsubscribeFromDatasetResultJsonUnmarshaller;
import com.amazonaws.services.cognitosync.model.transform.UpdateRecordsRequestProtocolMarshaller;
import com.amazonaws.services.cognitosync.model.transform.UpdateRecordsResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonCognitoSyncClient
extends AmazonWebServiceClient
implements AmazonCognitoSync {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCognitoSync.class);
    private static final String DEFAULT_SIGNING_NAME = "cognito-sync";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModification").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidConfiguration").withModeledClass(InvalidConfigurationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameter").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFound").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRequest").withModeledClass(DuplicateRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceConflict").withModeledClass(ResourceConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LambdaThrottled").withModeledClass(LambdaThrottledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotAuthorizedError").withModeledClass(NotAuthorizedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalError").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequests").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLambdaFunctionOutput").withModeledClass(InvalidLambdaFunctionOutputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceeded").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AlreadyStreamed").withModeledClass(AlreadyStreamedException.class)).withBaseServiceExceptionClass(AmazonCognitoSyncException.class));

    @Deprecated
    public AmazonCognitoSyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    @Deprecated
    public AmazonCognitoSyncClient(ClientConfiguration clientConfiguration) {
        this(DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    @Deprecated
    public AmazonCognitoSyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonCognitoSyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    @Deprecated
    public AmazonCognitoSyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonCognitoSyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonCognitoSyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public static AmazonCognitoSyncClientBuilder builder() {
        return AmazonCognitoSyncClientBuilder.standard();
    }

    AmazonCognitoSyncClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://cognito-sync.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cognitosync/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cognitosync/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BulkPublishResult bulkPublish(BulkPublishRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeBulkPublish(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BulkPublishResult executeBulkPublish(BulkPublishRequest bulkPublishRequest) {
        ExecutionContext executionContext = this.createExecutionContext(bulkPublishRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BulkPublishRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BulkPublishRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(bulkPublishRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new BulkPublishResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BulkPublishResult bulkPublishResult = (BulkPublishResult)response.getAwsResponse();
            return bulkPublishResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDeleteDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDatasetResult executeDeleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatasetRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDatasetResult deleteDatasetResult = (DeleteDatasetResult)response.getAwsResponse();
            return deleteDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDatasetResult executeDescribeDataset(DescribeDatasetRequest describeDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDatasetRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDatasetResult describeDatasetResult = (DescribeDatasetResult)response.getAwsResponse();
            return describeDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeIdentityPoolUsageResult describeIdentityPoolUsage(DescribeIdentityPoolUsageRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeIdentityPoolUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeIdentityPoolUsageResult executeDescribeIdentityPoolUsage(DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeIdentityPoolUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIdentityPoolUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIdentityPoolUsageRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeIdentityPoolUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeIdentityPoolUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeIdentityPoolUsageResult describeIdentityPoolUsageResult = (DescribeIdentityPoolUsageResult)response.getAwsResponse();
            return describeIdentityPoolUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeIdentityUsageResult describeIdentityUsage(DescribeIdentityUsageRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeDescribeIdentityUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeIdentityUsageResult executeDescribeIdentityUsage(DescribeIdentityUsageRequest describeIdentityUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeIdentityUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIdentityUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIdentityUsageRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeIdentityUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeIdentityUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeIdentityUsageResult describeIdentityUsageResult = (DescribeIdentityUsageResult)response.getAwsResponse();
            return describeIdentityUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBulkPublishDetailsResult getBulkPublishDetails(GetBulkPublishDetailsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetBulkPublishDetails(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBulkPublishDetailsResult executeGetBulkPublishDetails(GetBulkPublishDetailsRequest getBulkPublishDetailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBulkPublishDetailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBulkPublishDetailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBulkPublishDetailsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getBulkPublishDetailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetBulkPublishDetailsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBulkPublishDetailsResult getBulkPublishDetailsResult = (GetBulkPublishDetailsResult)response.getAwsResponse();
            return getBulkPublishDetailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCognitoEventsResult getCognitoEvents(GetCognitoEventsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetCognitoEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCognitoEventsResult executeGetCognitoEvents(GetCognitoEventsRequest getCognitoEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCognitoEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCognitoEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCognitoEventsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getCognitoEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetCognitoEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCognitoEventsResult getCognitoEventsResult = (GetCognitoEventsResult)response.getAwsResponse();
            return getCognitoEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetIdentityPoolConfigurationResult getIdentityPoolConfiguration(GetIdentityPoolConfigurationRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeGetIdentityPoolConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetIdentityPoolConfigurationResult executeGetIdentityPoolConfiguration(GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIdentityPoolConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIdentityPoolConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIdentityPoolConfigurationRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(getIdentityPoolConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new GetIdentityPoolConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetIdentityPoolConfigurationResult getIdentityPoolConfigurationResult = (GetIdentityPoolConfigurationResult)response.getAwsResponse();
            return getIdentityPoolConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListDatasets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDatasetsResult executeListDatasets(ListDatasetsRequest listDatasetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDatasetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatasetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatasetsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(listDatasetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListDatasetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDatasetsResult listDatasetsResult = (ListDatasetsResult)response.getAwsResponse();
            return listDatasetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListIdentityPoolUsageResult listIdentityPoolUsage(ListIdentityPoolUsageRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListIdentityPoolUsage(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListIdentityPoolUsageResult executeListIdentityPoolUsage(ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIdentityPoolUsageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIdentityPoolUsageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIdentityPoolUsageRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(listIdentityPoolUsageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListIdentityPoolUsageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListIdentityPoolUsageResult listIdentityPoolUsageResult = (ListIdentityPoolUsageResult)response.getAwsResponse();
            return listIdentityPoolUsageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRecordsResult listRecords(ListRecordsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeListRecords(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRecordsResult executeListRecords(ListRecordsRequest listRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRecordsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(listRecordsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ListRecordsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRecordsResult listRecordsResult = (ListRecordsResult)response.getAwsResponse();
            return listRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RegisterDeviceResult registerDevice(RegisterDeviceRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeRegisterDevice(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RegisterDeviceResult executeRegisterDevice(RegisterDeviceRequest registerDeviceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerDeviceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterDeviceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterDeviceRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(registerDeviceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new RegisterDeviceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RegisterDeviceResult registerDeviceResult = (RegisterDeviceResult)response.getAwsResponse();
            return registerDeviceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SetCognitoEventsResult setCognitoEvents(SetCognitoEventsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeSetCognitoEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SetCognitoEventsResult executeSetCognitoEvents(SetCognitoEventsRequest setCognitoEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setCognitoEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetCognitoEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetCognitoEventsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(setCognitoEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new SetCognitoEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetCognitoEventsResult setCognitoEventsResult = (SetCognitoEventsResult)response.getAwsResponse();
            return setCognitoEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SetIdentityPoolConfigurationResult setIdentityPoolConfiguration(SetIdentityPoolConfigurationRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeSetIdentityPoolConfiguration(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SetIdentityPoolConfigurationResult executeSetIdentityPoolConfiguration(SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setIdentityPoolConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetIdentityPoolConfigurationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetIdentityPoolConfigurationRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(setIdentityPoolConfigurationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new SetIdentityPoolConfigurationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetIdentityPoolConfigurationResult setIdentityPoolConfigurationResult = (SetIdentityPoolConfigurationResult)response.getAwsResponse();
            return setIdentityPoolConfigurationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SubscribeToDatasetResult subscribeToDataset(SubscribeToDatasetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeSubscribeToDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final SubscribeToDatasetResult executeSubscribeToDataset(SubscribeToDatasetRequest subscribeToDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(subscribeToDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubscribeToDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubscribeToDatasetRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(subscribeToDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new SubscribeToDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SubscribeToDatasetResult subscribeToDatasetResult = (SubscribeToDatasetResult)response.getAwsResponse();
            return subscribeToDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UnsubscribeFromDatasetResult unsubscribeFromDataset(UnsubscribeFromDatasetRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUnsubscribeFromDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UnsubscribeFromDatasetResult executeUnsubscribeFromDataset(UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(unsubscribeFromDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UnsubscribeFromDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UnsubscribeFromDatasetRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(unsubscribeFromDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UnsubscribeFromDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UnsubscribeFromDatasetResult unsubscribeFromDatasetResult = (UnsubscribeFromDatasetResult)response.getAwsResponse();
            return unsubscribeFromDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRecordsResult updateRecords(UpdateRecordsRequest request) {
        request = this.beforeClientExecution(request);
        return this.executeUpdateRecords(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRecordsResult executeUpdateRecords(UpdateRecordsRequest updateRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRecordsRequestProtocolMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(updateRecordsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new UpdateRecordsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRecordsResult updateRecordsResult = (UpdateRecordsResult)response.getAwsResponse();
            return updateRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

