/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.DescribeAppsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeAppsRequestMarshaller
implements Marshaller<Request<DescribeAppsRequest>, DescribeAppsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeAppsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeAppsRequest> marshall(DescribeAppsRequest describeAppsRequest) {
        if (describeAppsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAppsRequest> request = new DefaultRequest<DescribeAppsRequest>(describeAppsRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeApps");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList appIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeAppsRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(describeAppsRequest.getStackId());
            }
            if (!(appIdsList = (SdkInternalList)describeAppsRequest.getAppIds()).isEmpty() || !appIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("AppIds");
                jsonGenerator.writeStartArray();
                for (String appIdsListValue : appIdsList) {
                    if (appIdsListValue == null) continue;
                    jsonGenerator.writeValue(appIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

