/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeClassicLinkInstancesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeClassicLinkInstancesRequestMarshaller
implements Marshaller<Request<DescribeClassicLinkInstancesRequest>, DescribeClassicLinkInstancesRequest> {
    @Override
    public Request<DescribeClassicLinkInstancesRequest> marshall(DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest) {
        SdkInternalList filtersList;
        if (describeClassicLinkInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeClassicLinkInstancesRequest> request = new DefaultRequest<DescribeClassicLinkInstancesRequest>(describeClassicLinkInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeClassicLinkInstances");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList instanceIdsList = (SdkInternalList)describeClassicLinkInstancesRequest.getInstanceIds();
        if (!instanceIdsList.isEmpty() || !instanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString(instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (!(filtersList = (SdkInternalList)describeClassicLinkInstancesRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeClassicLinkInstancesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeClassicLinkInstancesRequest.getNextToken()));
        }
        if (describeClassicLinkInstancesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeClassicLinkInstancesRequest.getMaxResults()));
        }
        return request;
    }
}

