/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.PriceScheduleSpecification;
import com.amazonaws.services.ec2.model.transform.CreateReservedInstancesListingRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateReservedInstancesListingRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateReservedInstancesListingRequest> {
    private String reservedInstancesId;
    private Integer instanceCount;
    private SdkInternalList<PriceScheduleSpecification> priceSchedules;
    private String clientToken;

    public void setReservedInstancesId(String reservedInstancesId) {
        this.reservedInstancesId = reservedInstancesId;
    }

    public String getReservedInstancesId() {
        return this.reservedInstancesId;
    }

    public CreateReservedInstancesListingRequest withReservedInstancesId(String reservedInstancesId) {
        this.setReservedInstancesId(reservedInstancesId);
        return this;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public CreateReservedInstancesListingRequest withInstanceCount(Integer instanceCount) {
        this.setInstanceCount(instanceCount);
        return this;
    }

    public List<PriceScheduleSpecification> getPriceSchedules() {
        if (this.priceSchedules == null) {
            this.priceSchedules = new SdkInternalList();
        }
        return this.priceSchedules;
    }

    public void setPriceSchedules(Collection<PriceScheduleSpecification> priceSchedules) {
        if (priceSchedules == null) {
            this.priceSchedules = null;
            return;
        }
        this.priceSchedules = new SdkInternalList<PriceScheduleSpecification>(priceSchedules);
    }

    public CreateReservedInstancesListingRequest withPriceSchedules(PriceScheduleSpecification ... priceSchedules) {
        if (this.priceSchedules == null) {
            this.setPriceSchedules(new SdkInternalList<PriceScheduleSpecification>(priceSchedules.length));
        }
        for (PriceScheduleSpecification ele : priceSchedules) {
            this.priceSchedules.add(ele);
        }
        return this;
    }

    public CreateReservedInstancesListingRequest withPriceSchedules(Collection<PriceScheduleSpecification> priceSchedules) {
        this.setPriceSchedules(priceSchedules);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateReservedInstancesListingRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    @Override
    public Request<CreateReservedInstancesListingRequest> getDryRunRequest() {
        Request<CreateReservedInstancesListingRequest> request = new CreateReservedInstancesListingRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReservedInstancesId() != null) {
            sb.append("ReservedInstancesId: " + this.getReservedInstancesId() + ",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: " + this.getInstanceCount() + ",");
        }
        if (this.getPriceSchedules() != null) {
            sb.append("PriceSchedules: " + this.getPriceSchedules() + ",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReservedInstancesListingRequest)) {
            return false;
        }
        CreateReservedInstancesListingRequest other = (CreateReservedInstancesListingRequest)obj;
        if (other.getReservedInstancesId() == null ^ this.getReservedInstancesId() == null) {
            return false;
        }
        if (other.getReservedInstancesId() != null && !other.getReservedInstancesId().equals(this.getReservedInstancesId())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getPriceSchedules() == null ^ this.getPriceSchedules() == null) {
            return false;
        }
        if (other.getPriceSchedules() != null && !other.getPriceSchedules().equals(this.getPriceSchedules())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReservedInstancesId() == null ? 0 : this.getReservedInstancesId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getPriceSchedules() == null ? 0 : this.getPriceSchedules().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    @Override
    public CreateReservedInstancesListingRequest clone() {
        return (CreateReservedInstancesListingRequest)super.clone();
    }
}

