/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.BooleanToBooleanMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.marshallers.CustomMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.CustomUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@SdkInternalApi
final class DynamoDBMappingsRegistry {
    private static final DynamoDBMappingsRegistry INSTANCE = new DynamoDBMappingsRegistry();
    private final ConcurrentMap<Class<?>, Mappings> mappings = new ConcurrentHashMap();

    DynamoDBMappingsRegistry() {
    }

    static final DynamoDBMappingsRegistry instance() {
        return INSTANCE;
    }

    final Mappings mappingsOf(Class<?> clazz) {
        if (!this.mappings.containsKey(clazz)) {
            this.mappings.putIfAbsent(clazz, new Mappings(clazz));
        }
        return (Mappings)this.mappings.get(clazz);
    }

    final Mapping mappingOf(Method method) {
        return this.mappingsOf(method.getDeclaringClass()).getMapping(method);
    }

    static final class Mapping {
        private final StandardBeanProperties.Bean<Object, Object> bean;
        private final String attributeName;

        private Mapping(String attributeName, StandardBeanProperties.Bean<Object, Object> bean) {
            this.attributeName = attributeName;
            this.bean = bean;
        }

        final StandardBeanProperties.Bean<Object, Object> bean() {
            return this.bean;
        }

        final Method getter() {
            return this.bean.getter();
        }

        final boolean isPrimaryKey() {
            return this.bean.annotations().keyType() != null;
        }

        final boolean isHashKey() {
            return this.bean.annotations().hashKey() != null;
        }

        final boolean isIndexHashKey() {
            return this.bean.annotations().indexHashKey() != null;
        }

        final boolean isVersion() {
            return this.bean.annotations().versioned();
        }

        final String getAttributeName() {
            return this.attributeName;
        }

        final ArgumentMarshaller getCustomMarshaller() {
            if (this.bean.annotations().marshalling() != null) {
                return new CustomMarshaller(this.bean.annotations().marshalling().marshallerClass());
            }
            if (this.bean.annotations().nativeBoolean() != null) {
                return BooleanToBooleanMarshaller.instance();
            }
            return null;
        }

        final ArgumentUnmarshaller getCustomUnmarshaller() {
            if (this.bean.annotations().marshalling() != null) {
                return new CustomUnmarshaller(this.bean.reflect().valueType(), this.bean.annotations().marshalling().marshallerClass());
            }
            return null;
        }

        final boolean canGenerate(Object object, DynamoDBMapperConfig.SaveBehavior saveBehavior) {
            if (this.bean.getGenerateStrategy() == null) {
                return false;
            }
            if (DynamoDBAutoGenerateStrategy.ALWAYS == this.bean.getGenerateStrategy()) {
                return true;
            }
            if (this.bean.get(object) != null) {
                return false;
            }
            if (this.bean.annotations().keyType() != null || this.bean.annotations().indexed()) {
                return true;
            }
            if (saveBehavior == DynamoDBMapperConfig.SaveBehavior.CLOBBER || saveBehavior == DynamoDBMapperConfig.SaveBehavior.UPDATE) {
                return true;
            }
            return DynamoDBMappingsRegistry.instance().mappingsOf(object.getClass()).anyKeyGeneratable(object, saveBehavior);
        }
    }

    static final class Mappings {
        private final Class<Object> objectType;
        private final Map<String, Mapping> byNames = new HashMap<String, Mapping>();
        private final Map<Method, Mapping> byGetters = new HashMap<Method, Mapping>();
        private final Map<KeyType, Mapping> byKeyTypes = new HashMap<KeyType, Mapping>();

        private Mappings(Class<?> clazz) {
            this.objectType = clazz;
            for (Map.Entry bean : StandardBeanProperties.of(this.objectType).entrySet()) {
                Mapping mapping = new Mapping(bean.getKey(), bean.getValue());
                if (this.byNames.containsKey(mapping.getAttributeName())) {
                    throw new DynamoDBMappingException(this.objectType + " maps duplicate attributes named " + mapping.getAttributeName());
                }
                if (mapping.isPrimaryKey() && this.byKeyTypes.put(mapping.bean().annotations().keyType(), mapping) != null) {
                    throw new DynamoDBMappingException(this.objectType + " maps multiple " + (Object)((Object)mapping.bean().annotations().keyType()) + " key attributes");
                }
                this.byNames.put(mapping.getAttributeName(), mapping);
                this.byGetters.put(mapping.getter(), mapping);
            }
        }

        final Collection<Mapping> getMappings() {
            return this.byNames.values();
        }

        final Mapping getMapping(Method method) {
            Mapping mapping = this.byGetters.get(method);
            if (mapping == null) {
                throw new DynamoDBMappingException(this.objectType + " does not map any getter named " + method.getName());
            }
            return mapping;
        }

        final Collection<Mapping> getPrimaryKeys() {
            return this.byKeyTypes.values();
        }

        final Mapping getHashKey() {
            if (!this.byKeyTypes.containsKey((Object)KeyType.HASH)) {
                throw new DynamoDBMappingException(this.objectType + " does not map a @DynamoDBHashKey attribute; ensure a public, zero-parameter get method/field is annotated");
            }
            return this.byKeyTypes.get((Object)KeyType.HASH);
        }

        final boolean hasRangeKey() {
            return this.byKeyTypes.containsKey((Object)KeyType.RANGE);
        }

        final Mapping getRangeKey() {
            return this.byKeyTypes.get((Object)KeyType.RANGE);
        }

        final boolean anyKeyGeneratable(Object object, DynamoDBMapperConfig.SaveBehavior saveBehavior) {
            if (this.byKeyTypes.isEmpty()) {
                throw new DynamoDBMappingException("no key(s) present on " + this.objectType);
            }
            for (Mapping primaryKey : this.byKeyTypes.values()) {
                if (!primaryKey.canGenerate(object, saveBehavior)) continue;
                return true;
            }
            return false;
        }
    }
}

