/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.PEM;
import com.amazonaws.auth.RSA;
import com.amazonaws.util.Base64;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class SignerUtils {
    private static final SecureRandom srand = new SecureRandom();

    public static String buildCannedPolicy(String resourceUrlOrPath, Date dateLessThan) {
        return "{\"Statement\":[{\"Resource\":\"" + resourceUrlOrPath + "\",\"Condition\":{\"DateLessThan\":{\"AWS:EpochTime\":" + TimeUnit.MILLISECONDS.toSeconds(dateLessThan.getTime()) + "}}}]}";
    }

    public static String buildCustomPolicy(String resourcePath, Date expiresOn, Date activeFrom, String ipAddress) {
        return "{\"Statement\": [{\"Resource\":\"" + resourcePath + "\",\"Condition\":{\"DateLessThan\":{\"AWS:EpochTime\":" + TimeUnit.MILLISECONDS.toSeconds(expiresOn.getTime()) + "}" + (ipAddress == null ? "" : ",\"IpAddress\":{\"AWS:SourceIp\":\"" + ipAddress + "\"}") + (activeFrom == null ? "" : ",\"DateGreaterThan\":{\"AWS:EpochTime\":" + TimeUnit.MILLISECONDS.toSeconds(activeFrom.getTime()) + "}") + "}}]}";
    }

    public static String makeBytesUrlSafe(byte[] bytes) {
        byte[] encoded = Base64.encode(bytes);
        block5: for (int i = 0; i < encoded.length; ++i) {
            switch (encoded[i]) {
                case 43: {
                    encoded[i] = 45;
                    continue block5;
                }
                case 61: {
                    encoded[i] = 95;
                    continue block5;
                }
                case 47: {
                    encoded[i] = 126;
                    continue block5;
                }
            }
        }
        return new String(encoded, StringUtils.UTF8);
    }

    public static String makeStringUrlSafe(String str) {
        return SignerUtils.makeBytesUrlSafe(str.getBytes(StringUtils.UTF8));
    }

    public static String generateResourcePath(Protocol protocol, String distributionDomain, String resourcePath) {
        return protocol == Protocol.http || protocol == Protocol.https ? (Object)((Object)protocol) + "://" + distributionDomain + "/" + resourcePath : resourcePath;
    }

    public static byte[] signWithSha1RSA(byte[] dataToSign, PrivateKey privateKey) throws InvalidKeyException {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey, srand);
            signature.update(dataToSign);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (SignatureException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey loadPrivateKey(File privateKeyFile) throws InvalidKeySpecException, IOException {
        if (StringUtils.lowerCase(privateKeyFile.getAbsolutePath()).endsWith(".pem")) {
            FileInputStream is = new FileInputStream(privateKeyFile);
            try {
                PrivateKey privateKey = PEM.readPrivateKey(is);
                return privateKey;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (StringUtils.lowerCase(privateKeyFile.getAbsolutePath()).endsWith(".der")) {
            FileInputStream is = new FileInputStream(privateKeyFile);
            try {
                PrivateKey privateKey = RSA.privateKeyFromPKCS8(IOUtils.toByteArray(is));
                return privateKey;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new AmazonClientException("Unsupported file type for private key");
    }

    public static PrivateKey loadPrivateKey(String privateKeyFilePath) throws InvalidKeySpecException, IOException {
        File privateKeyFile = new File(privateKeyFilePath);
        return SignerUtils.loadPrivateKey(privateKeyFile);
    }

    public static enum Protocol {
        http,
        https,
        rtmp;

    }
}

