/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidentity.model.UnlinkIdentityRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;

public class UnlinkIdentityRequestMarshaller
implements Marshaller<Request<UnlinkIdentityRequest>, UnlinkIdentityRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UnlinkIdentityRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UnlinkIdentityRequest> marshall(UnlinkIdentityRequest unlinkIdentityRequest) {
        if (unlinkIdentityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UnlinkIdentityRequest> request = new DefaultRequest<UnlinkIdentityRequest>(unlinkIdentityRequest, "AmazonCognitoIdentity");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityService.UnlinkIdentity");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> loginsToRemoveList;
            Map<String, String> loginsMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (unlinkIdentityRequest.getIdentityId() != null) {
                jsonGenerator.writeFieldName("IdentityId").writeValue(unlinkIdentityRequest.getIdentityId());
            }
            if ((loginsMap = unlinkIdentityRequest.getLogins()) != null) {
                jsonGenerator.writeFieldName("Logins");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> loginsMapValue : loginsMap.entrySet()) {
                    if (loginsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(loginsMapValue.getKey());
                    jsonGenerator.writeValue(loginsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((loginsToRemoveList = unlinkIdentityRequest.getLoginsToRemove()) != null) {
                jsonGenerator.writeFieldName("LoginsToRemove");
                jsonGenerator.writeStartArray();
                for (String loginsToRemoveListValue : loginsToRemoveList) {
                    if (loginsToRemoveListValue == null) continue;
                    jsonGenerator.writeValue(loginsToRemoveListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

