/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.PrefixListId;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RevokeSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<RevokeSecurityGroupIngressRequest>, RevokeSecurityGroupIngressRequest> {
    @Override
    public Request<RevokeSecurityGroupIngressRequest> marshall(RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest) {
        SdkInternalList ipPermissionsList;
        if (revokeSecurityGroupIngressRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RevokeSecurityGroupIngressRequest> request = new DefaultRequest<RevokeSecurityGroupIngressRequest>(revokeSecurityGroupIngressRequest, "AmazonEC2");
        request.addParameter("Action", "RevokeSecurityGroupIngress");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeSecurityGroupIngressRequest.getGroupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(revokeSecurityGroupIngressRequest.getGroupName()));
        }
        if (revokeSecurityGroupIngressRequest.getGroupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString(revokeSecurityGroupIngressRequest.getGroupId()));
        }
        if (revokeSecurityGroupIngressRequest.getSourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString(revokeSecurityGroupIngressRequest.getSourceSecurityGroupName()));
        }
        if (revokeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString(revokeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId()));
        }
        if (revokeSecurityGroupIngressRequest.getIpProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString(revokeSecurityGroupIngressRequest.getIpProtocol()));
        }
        if (revokeSecurityGroupIngressRequest.getFromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequest.getFromPort()));
        }
        if (revokeSecurityGroupIngressRequest.getToPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger(revokeSecurityGroupIngressRequest.getToPort()));
        }
        if (revokeSecurityGroupIngressRequest.getCidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString(revokeSecurityGroupIngressRequest.getCidrIp()));
        }
        if (!(ipPermissionsList = (SdkInternalList)revokeSecurityGroupIngressRequest.getIpPermissions()).isEmpty() || !ipPermissionsList.isAutoConstruct()) {
            int ipPermissionsListIndex = 1;
            for (IpPermission ipPermissionsListValue : ipPermissionsList) {
                SdkInternalList prefixListIdsList;
                SdkInternalList ipRangesList;
                SdkInternalList userIdGroupPairsList;
                if (ipPermissionsListValue.getIpProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString(ipPermissionsListValue.getIpProtocol()));
                }
                if (ipPermissionsListValue.getFromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger(ipPermissionsListValue.getFromPort()));
                }
                if (ipPermissionsListValue.getToPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger(ipPermissionsListValue.getToPort()));
                }
                if (!(userIdGroupPairsList = (SdkInternalList)ipPermissionsListValue.getUserIdGroupPairs()).isEmpty() || !userIdGroupPairsList.isAutoConstruct()) {
                    int userIdGroupPairsListIndex = 1;
                    for (UserIdGroupPair userIdGroupPairsListValue : userIdGroupPairsList) {
                        if (userIdGroupPairsListValue.getUserId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString(userIdGroupPairsListValue.getUserId()));
                        }
                        if (userIdGroupPairsListValue.getGroupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString(userIdGroupPairsListValue.getGroupName()));
                        }
                        if (userIdGroupPairsListValue.getGroupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString(userIdGroupPairsListValue.getGroupId()));
                        }
                        if (userIdGroupPairsListValue.getVpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString(userIdGroupPairsListValue.getVpcId()));
                        }
                        if (userIdGroupPairsListValue.getVpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString(userIdGroupPairsListValue.getVpcPeeringConnectionId()));
                        }
                        if (userIdGroupPairsListValue.getPeeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString(userIdGroupPairsListValue.getPeeringStatus()));
                        }
                        ++userIdGroupPairsListIndex;
                    }
                }
                if (!(ipRangesList = (SdkInternalList)ipPermissionsListValue.getIpRanges()).isEmpty() || !ipRangesList.isAutoConstruct()) {
                    int ipRangesListIndex = 1;
                    for (String ipRangesListValue : ipRangesList) {
                        if (ipRangesListValue != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipRangesListIndex + ".CidrIp", StringUtils.fromString(ipRangesListValue));
                        }
                        ++ipRangesListIndex;
                    }
                }
                if (!(prefixListIdsList = (SdkInternalList)ipPermissionsListValue.getPrefixListIds()).isEmpty() || !prefixListIdsList.isAutoConstruct()) {
                    int prefixListIdsListIndex = 1;
                    for (PrefixListId prefixListIdsListValue : prefixListIdsList) {
                        if (prefixListIdsListValue.getPrefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString(prefixListIdsListValue.getPrefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        return request;
    }
}

