/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.transform.NewPublicVirtualInterfaceAllocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AllocatePublicVirtualInterfaceRequestMarshaller
implements Marshaller<Request<AllocatePublicVirtualInterfaceRequest>, AllocatePublicVirtualInterfaceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AllocatePublicVirtualInterfaceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AllocatePublicVirtualInterfaceRequest> marshall(AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest) {
        if (allocatePublicVirtualInterfaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AllocatePublicVirtualInterfaceRequest> request = new DefaultRequest<AllocatePublicVirtualInterfaceRequest>(allocatePublicVirtualInterfaceRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.AllocatePublicVirtualInterface");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (allocatePublicVirtualInterfaceRequest.getConnectionId() != null) {
                jsonGenerator.writeFieldName("connectionId").writeValue(allocatePublicVirtualInterfaceRequest.getConnectionId());
            }
            if (allocatePublicVirtualInterfaceRequest.getOwnerAccount() != null) {
                jsonGenerator.writeFieldName("ownerAccount").writeValue(allocatePublicVirtualInterfaceRequest.getOwnerAccount());
            }
            if (allocatePublicVirtualInterfaceRequest.getNewPublicVirtualInterfaceAllocation() != null) {
                jsonGenerator.writeFieldName("newPublicVirtualInterfaceAllocation");
                NewPublicVirtualInterfaceAllocationJsonMarshaller.getInstance().marshall(allocatePublicVirtualInterfaceRequest.getNewPublicVirtualInterfaceAllocation(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

