/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudtrail.model.ListTagsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListTagsRequestMarshaller
implements Marshaller<Request<ListTagsRequest>, ListTagsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListTagsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListTagsRequest> marshall(ListTagsRequest listTagsRequest) {
        if (listTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTagsRequest> request = new DefaultRequest<ListTagsRequest>(listTagsRequest, "AWSCloudTrail");
        request.addHeader("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.ListTags");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList resourceIdListList = (SdkInternalList)listTagsRequest.getResourceIdList();
            if (!resourceIdListList.isEmpty() || !resourceIdListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ResourceIdList");
                jsonGenerator.writeStartArray();
                for (String resourceIdListListValue : resourceIdListList) {
                    if (resourceIdListListValue == null) continue;
                    jsonGenerator.writeValue(resourceIdListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listTagsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listTagsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

