/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.invoke;

import com.amazonaws.AmazonClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.util.CollectionUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LambdaFunctionException
extends AmazonClientException {
    private final String errorType;
    private final List<List<String>> stackTraces;
    private String functionError;

    @Deprecated
    public LambdaFunctionException(String message, boolean handled, String type) {
        this(type, message, null, null);
        this.setFunctionError(handled ? "Handeled" : "Unhandled");
    }

    @SdkInternalApi
    LambdaFunctionException(String errorMessage, String functionError) {
        this(null, errorMessage, null, null);
        this.setFunctionError(functionError);
    }

    @JsonCreator
    @SdkInternalApi
    LambdaFunctionException(@JsonProperty(value="errorType") String errorType, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="cause") LambdaFunctionException cause, @JsonProperty(value="stackTrace") List<List<String>> stackTraces) {
        super(errorMessage, cause);
        this.errorType = errorType;
        this.stackTraces = stackTraces == null ? Collections.emptyList() : stackTraces;
    }

    public String getType() {
        return this.errorType;
    }

    public boolean isHandled() {
        return "Handled".equals(this.functionError);
    }

    @Override
    public synchronized LambdaFunctionException getCause() {
        return (LambdaFunctionException)super.getCause();
    }

    @SdkInternalApi
    void setFunctionError(String functionError) {
        this.functionError = functionError;
    }

    @SdkInternalApi
    void fillInStackTrace(Class<?> interfaceClass) {
        if (this.stackTraces != null) {
            ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
            for (List<String> stackTrace : this.stackTraces) {
                String methodName = CollectionUtils.join(stackTrace, ",").trim();
                elements.add(new StackTraceElement(interfaceClass.getName(), methodName, null, -1));
            }
            this.setStackTrace(elements.toArray(new StackTraceElement[elements.size()]));
        }
        if (this.getCause() != null) {
            this.getCause().fillInStackTrace(interfaceClass);
        }
    }
}

