/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.services.rds.model.SourceType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DescribeEventsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String sourceIdentifier;
    private String sourceType;
    private Date startTime;
    private Date endTime;
    private Integer duration;
    private SdkInternalList<String> eventCategories;
    private SdkInternalList<Filter> filters;
    private Integer maxRecords;
    private String marker;

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public DescribeEventsRequest withSourceIdentifier(String sourceIdentifier) {
        this.setSourceIdentifier(sourceIdentifier);
        return this;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public DescribeEventsRequest withSourceType(String sourceType) {
        this.setSourceType(sourceType);
        return this;
    }

    @JsonIgnore
    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType.toString();
    }

    public DescribeEventsRequest withSourceType(SourceType sourceType) {
        this.setSourceType(sourceType);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public DescribeEventsRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public DescribeEventsRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public DescribeEventsRequest withDuration(Integer duration) {
        this.setDuration(duration);
        return this;
    }

    public List<String> getEventCategories() {
        if (this.eventCategories == null) {
            this.eventCategories = new SdkInternalList();
        }
        return this.eventCategories;
    }

    public void setEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
            return;
        }
        this.eventCategories = new SdkInternalList<String>(eventCategories);
    }

    public DescribeEventsRequest withEventCategories(String ... eventCategories) {
        if (this.eventCategories == null) {
            this.setEventCategories(new SdkInternalList<String>(eventCategories.length));
        }
        for (String ele : eventCategories) {
            this.eventCategories.add(ele);
        }
        return this;
    }

    public DescribeEventsRequest withEventCategories(Collection<String> eventCategories) {
        this.setEventCategories(eventCategories);
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList<Filter>(filters);
    }

    public DescribeEventsRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new SdkInternalList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DescribeEventsRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public DescribeEventsRequest withMaxRecords(Integer maxRecords) {
        this.setMaxRecords(maxRecords);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeEventsRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceIdentifier() != null) {
            sb.append("SourceIdentifier: ").append(this.getSourceIdentifier()).append(",");
        }
        if (this.getSourceType() != null) {
            sb.append("SourceType: ").append(this.getSourceType()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: ").append(this.getDuration()).append(",");
        }
        if (this.getEventCategories() != null) {
            sb.append("EventCategories: ").append(this.getEventCategories()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMaxRecords() != null) {
            sb.append("MaxRecords: ").append(this.getMaxRecords()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsRequest)) {
            return false;
        }
        DescribeEventsRequest other = (DescribeEventsRequest)obj;
        if (other.getSourceIdentifier() == null ^ this.getSourceIdentifier() == null) {
            return false;
        }
        if (other.getSourceIdentifier() != null && !other.getSourceIdentifier().equals(this.getSourceIdentifier())) {
            return false;
        }
        if (other.getSourceType() == null ^ this.getSourceType() == null) {
            return false;
        }
        if (other.getSourceType() != null && !other.getSourceType().equals(this.getSourceType())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getEventCategories() == null ^ this.getEventCategories() == null) {
            return false;
        }
        if (other.getEventCategories() != null && !other.getEventCategories().equals(this.getEventCategories())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxRecords() == null ^ this.getMaxRecords() == null) {
            return false;
        }
        if (other.getMaxRecords() != null && !other.getMaxRecords().equals(this.getMaxRecords())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceIdentifier() == null ? 0 : this.getSourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSourceType() == null ? 0 : this.getSourceType().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode = 31 * hashCode + (this.getEventCategories() == null ? 0 : this.getEventCategories().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRecords() == null ? 0 : this.getMaxRecords().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    @Override
    public DescribeEventsRequest clone() {
        return (DescribeEventsRequest)super.clone();
    }
}

