/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.CustomAmi;
import com.amazonaws.services.elasticbeanstalk.model.PlatformFramework;
import com.amazonaws.services.elasticbeanstalk.model.PlatformProgrammingLanguage;
import com.amazonaws.services.elasticbeanstalk.model.PlatformStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class PlatformDescription
implements Serializable,
Cloneable {
    private String platformArn;
    private String platformOwner;
    private String platformName;
    private String platformVersion;
    private String solutionStackName;
    private String platformStatus;
    private Date dateCreated;
    private Date dateUpdated;
    private String platformCategory;
    private String description;
    private String maintainer;
    private String operatingSystemName;
    private String operatingSystemVersion;
    private SdkInternalList<PlatformProgrammingLanguage> programmingLanguages;
    private SdkInternalList<PlatformFramework> frameworks;
    private SdkInternalList<CustomAmi> customAmiList;
    private SdkInternalList<String> supportedTierList;
    private SdkInternalList<String> supportedAddonList;

    public void setPlatformArn(String platformArn) {
        this.platformArn = platformArn;
    }

    public String getPlatformArn() {
        return this.platformArn;
    }

    public PlatformDescription withPlatformArn(String platformArn) {
        this.setPlatformArn(platformArn);
        return this;
    }

    public void setPlatformOwner(String platformOwner) {
        this.platformOwner = platformOwner;
    }

    public String getPlatformOwner() {
        return this.platformOwner;
    }

    public PlatformDescription withPlatformOwner(String platformOwner) {
        this.setPlatformOwner(platformOwner);
        return this;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public PlatformDescription withPlatformName(String platformName) {
        this.setPlatformName(platformName);
        return this;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public PlatformDescription withPlatformVersion(String platformVersion) {
        this.setPlatformVersion(platformVersion);
        return this;
    }

    public void setSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
    }

    public String getSolutionStackName() {
        return this.solutionStackName;
    }

    public PlatformDescription withSolutionStackName(String solutionStackName) {
        this.setSolutionStackName(solutionStackName);
        return this;
    }

    public void setPlatformStatus(String platformStatus) {
        this.platformStatus = platformStatus;
    }

    public String getPlatformStatus() {
        return this.platformStatus;
    }

    public PlatformDescription withPlatformStatus(String platformStatus) {
        this.setPlatformStatus(platformStatus);
        return this;
    }

    @JsonIgnore
    public void setPlatformStatus(PlatformStatus platformStatus) {
        this.platformStatus = platformStatus.toString();
    }

    public PlatformDescription withPlatformStatus(PlatformStatus platformStatus) {
        this.setPlatformStatus(platformStatus);
        return this;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public PlatformDescription withDateCreated(Date dateCreated) {
        this.setDateCreated(dateCreated);
        return this;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public PlatformDescription withDateUpdated(Date dateUpdated) {
        this.setDateUpdated(dateUpdated);
        return this;
    }

    public void setPlatformCategory(String platformCategory) {
        this.platformCategory = platformCategory;
    }

    public String getPlatformCategory() {
        return this.platformCategory;
    }

    public PlatformDescription withPlatformCategory(String platformCategory) {
        this.setPlatformCategory(platformCategory);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public PlatformDescription withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setMaintainer(String maintainer) {
        this.maintainer = maintainer;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public PlatformDescription withMaintainer(String maintainer) {
        this.setMaintainer(maintainer);
        return this;
    }

    public void setOperatingSystemName(String operatingSystemName) {
        this.operatingSystemName = operatingSystemName;
    }

    public String getOperatingSystemName() {
        return this.operatingSystemName;
    }

    public PlatformDescription withOperatingSystemName(String operatingSystemName) {
        this.setOperatingSystemName(operatingSystemName);
        return this;
    }

    public void setOperatingSystemVersion(String operatingSystemVersion) {
        this.operatingSystemVersion = operatingSystemVersion;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public PlatformDescription withOperatingSystemVersion(String operatingSystemVersion) {
        this.setOperatingSystemVersion(operatingSystemVersion);
        return this;
    }

    public List<PlatformProgrammingLanguage> getProgrammingLanguages() {
        if (this.programmingLanguages == null) {
            this.programmingLanguages = new SdkInternalList();
        }
        return this.programmingLanguages;
    }

    public void setProgrammingLanguages(Collection<PlatformProgrammingLanguage> programmingLanguages) {
        if (programmingLanguages == null) {
            this.programmingLanguages = null;
            return;
        }
        this.programmingLanguages = new SdkInternalList<PlatformProgrammingLanguage>(programmingLanguages);
    }

    public PlatformDescription withProgrammingLanguages(PlatformProgrammingLanguage ... programmingLanguages) {
        if (this.programmingLanguages == null) {
            this.setProgrammingLanguages(new SdkInternalList<PlatformProgrammingLanguage>(programmingLanguages.length));
        }
        for (PlatformProgrammingLanguage ele : programmingLanguages) {
            this.programmingLanguages.add(ele);
        }
        return this;
    }

    public PlatformDescription withProgrammingLanguages(Collection<PlatformProgrammingLanguage> programmingLanguages) {
        this.setProgrammingLanguages(programmingLanguages);
        return this;
    }

    public List<PlatformFramework> getFrameworks() {
        if (this.frameworks == null) {
            this.frameworks = new SdkInternalList();
        }
        return this.frameworks;
    }

    public void setFrameworks(Collection<PlatformFramework> frameworks) {
        if (frameworks == null) {
            this.frameworks = null;
            return;
        }
        this.frameworks = new SdkInternalList<PlatformFramework>(frameworks);
    }

    public PlatformDescription withFrameworks(PlatformFramework ... frameworks) {
        if (this.frameworks == null) {
            this.setFrameworks(new SdkInternalList<PlatformFramework>(frameworks.length));
        }
        for (PlatformFramework ele : frameworks) {
            this.frameworks.add(ele);
        }
        return this;
    }

    public PlatformDescription withFrameworks(Collection<PlatformFramework> frameworks) {
        this.setFrameworks(frameworks);
        return this;
    }

    public List<CustomAmi> getCustomAmiList() {
        if (this.customAmiList == null) {
            this.customAmiList = new SdkInternalList();
        }
        return this.customAmiList;
    }

    public void setCustomAmiList(Collection<CustomAmi> customAmiList) {
        if (customAmiList == null) {
            this.customAmiList = null;
            return;
        }
        this.customAmiList = new SdkInternalList<CustomAmi>(customAmiList);
    }

    public PlatformDescription withCustomAmiList(CustomAmi ... customAmiList) {
        if (this.customAmiList == null) {
            this.setCustomAmiList(new SdkInternalList<CustomAmi>(customAmiList.length));
        }
        for (CustomAmi ele : customAmiList) {
            this.customAmiList.add(ele);
        }
        return this;
    }

    public PlatformDescription withCustomAmiList(Collection<CustomAmi> customAmiList) {
        this.setCustomAmiList(customAmiList);
        return this;
    }

    public List<String> getSupportedTierList() {
        if (this.supportedTierList == null) {
            this.supportedTierList = new SdkInternalList();
        }
        return this.supportedTierList;
    }

    public void setSupportedTierList(Collection<String> supportedTierList) {
        if (supportedTierList == null) {
            this.supportedTierList = null;
            return;
        }
        this.supportedTierList = new SdkInternalList<String>(supportedTierList);
    }

    public PlatformDescription withSupportedTierList(String ... supportedTierList) {
        if (this.supportedTierList == null) {
            this.setSupportedTierList(new SdkInternalList<String>(supportedTierList.length));
        }
        for (String ele : supportedTierList) {
            this.supportedTierList.add(ele);
        }
        return this;
    }

    public PlatformDescription withSupportedTierList(Collection<String> supportedTierList) {
        this.setSupportedTierList(supportedTierList);
        return this;
    }

    public List<String> getSupportedAddonList() {
        if (this.supportedAddonList == null) {
            this.supportedAddonList = new SdkInternalList();
        }
        return this.supportedAddonList;
    }

    public void setSupportedAddonList(Collection<String> supportedAddonList) {
        if (supportedAddonList == null) {
            this.supportedAddonList = null;
            return;
        }
        this.supportedAddonList = new SdkInternalList<String>(supportedAddonList);
    }

    public PlatformDescription withSupportedAddonList(String ... supportedAddonList) {
        if (this.supportedAddonList == null) {
            this.setSupportedAddonList(new SdkInternalList<String>(supportedAddonList.length));
        }
        for (String ele : supportedAddonList) {
            this.supportedAddonList.add(ele);
        }
        return this;
    }

    public PlatformDescription withSupportedAddonList(Collection<String> supportedAddonList) {
        this.setSupportedAddonList(supportedAddonList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPlatformArn() != null) {
            sb.append("PlatformArn: ").append(this.getPlatformArn()).append(",");
        }
        if (this.getPlatformOwner() != null) {
            sb.append("PlatformOwner: ").append(this.getPlatformOwner()).append(",");
        }
        if (this.getPlatformName() != null) {
            sb.append("PlatformName: ").append(this.getPlatformName()).append(",");
        }
        if (this.getPlatformVersion() != null) {
            sb.append("PlatformVersion: ").append(this.getPlatformVersion()).append(",");
        }
        if (this.getSolutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.getSolutionStackName()).append(",");
        }
        if (this.getPlatformStatus() != null) {
            sb.append("PlatformStatus: ").append(this.getPlatformStatus()).append(",");
        }
        if (this.getDateCreated() != null) {
            sb.append("DateCreated: ").append(this.getDateCreated()).append(",");
        }
        if (this.getDateUpdated() != null) {
            sb.append("DateUpdated: ").append(this.getDateUpdated()).append(",");
        }
        if (this.getPlatformCategory() != null) {
            sb.append("PlatformCategory: ").append(this.getPlatformCategory()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getMaintainer() != null) {
            sb.append("Maintainer: ").append(this.getMaintainer()).append(",");
        }
        if (this.getOperatingSystemName() != null) {
            sb.append("OperatingSystemName: ").append(this.getOperatingSystemName()).append(",");
        }
        if (this.getOperatingSystemVersion() != null) {
            sb.append("OperatingSystemVersion: ").append(this.getOperatingSystemVersion()).append(",");
        }
        if (this.getProgrammingLanguages() != null) {
            sb.append("ProgrammingLanguages: ").append(this.getProgrammingLanguages()).append(",");
        }
        if (this.getFrameworks() != null) {
            sb.append("Frameworks: ").append(this.getFrameworks()).append(",");
        }
        if (this.getCustomAmiList() != null) {
            sb.append("CustomAmiList: ").append(this.getCustomAmiList()).append(",");
        }
        if (this.getSupportedTierList() != null) {
            sb.append("SupportedTierList: ").append(this.getSupportedTierList()).append(",");
        }
        if (this.getSupportedAddonList() != null) {
            sb.append("SupportedAddonList: ").append(this.getSupportedAddonList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformDescription)) {
            return false;
        }
        PlatformDescription other = (PlatformDescription)obj;
        if (other.getPlatformArn() == null ^ this.getPlatformArn() == null) {
            return false;
        }
        if (other.getPlatformArn() != null && !other.getPlatformArn().equals(this.getPlatformArn())) {
            return false;
        }
        if (other.getPlatformOwner() == null ^ this.getPlatformOwner() == null) {
            return false;
        }
        if (other.getPlatformOwner() != null && !other.getPlatformOwner().equals(this.getPlatformOwner())) {
            return false;
        }
        if (other.getPlatformName() == null ^ this.getPlatformName() == null) {
            return false;
        }
        if (other.getPlatformName() != null && !other.getPlatformName().equals(this.getPlatformName())) {
            return false;
        }
        if (other.getPlatformVersion() == null ^ this.getPlatformVersion() == null) {
            return false;
        }
        if (other.getPlatformVersion() != null && !other.getPlatformVersion().equals(this.getPlatformVersion())) {
            return false;
        }
        if (other.getSolutionStackName() == null ^ this.getSolutionStackName() == null) {
            return false;
        }
        if (other.getSolutionStackName() != null && !other.getSolutionStackName().equals(this.getSolutionStackName())) {
            return false;
        }
        if (other.getPlatformStatus() == null ^ this.getPlatformStatus() == null) {
            return false;
        }
        if (other.getPlatformStatus() != null && !other.getPlatformStatus().equals(this.getPlatformStatus())) {
            return false;
        }
        if (other.getDateCreated() == null ^ this.getDateCreated() == null) {
            return false;
        }
        if (other.getDateCreated() != null && !other.getDateCreated().equals(this.getDateCreated())) {
            return false;
        }
        if (other.getDateUpdated() == null ^ this.getDateUpdated() == null) {
            return false;
        }
        if (other.getDateUpdated() != null && !other.getDateUpdated().equals(this.getDateUpdated())) {
            return false;
        }
        if (other.getPlatformCategory() == null ^ this.getPlatformCategory() == null) {
            return false;
        }
        if (other.getPlatformCategory() != null && !other.getPlatformCategory().equals(this.getPlatformCategory())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getMaintainer() == null ^ this.getMaintainer() == null) {
            return false;
        }
        if (other.getMaintainer() != null && !other.getMaintainer().equals(this.getMaintainer())) {
            return false;
        }
        if (other.getOperatingSystemName() == null ^ this.getOperatingSystemName() == null) {
            return false;
        }
        if (other.getOperatingSystemName() != null && !other.getOperatingSystemName().equals(this.getOperatingSystemName())) {
            return false;
        }
        if (other.getOperatingSystemVersion() == null ^ this.getOperatingSystemVersion() == null) {
            return false;
        }
        if (other.getOperatingSystemVersion() != null && !other.getOperatingSystemVersion().equals(this.getOperatingSystemVersion())) {
            return false;
        }
        if (other.getProgrammingLanguages() == null ^ this.getProgrammingLanguages() == null) {
            return false;
        }
        if (other.getProgrammingLanguages() != null && !other.getProgrammingLanguages().equals(this.getProgrammingLanguages())) {
            return false;
        }
        if (other.getFrameworks() == null ^ this.getFrameworks() == null) {
            return false;
        }
        if (other.getFrameworks() != null && !other.getFrameworks().equals(this.getFrameworks())) {
            return false;
        }
        if (other.getCustomAmiList() == null ^ this.getCustomAmiList() == null) {
            return false;
        }
        if (other.getCustomAmiList() != null && !other.getCustomAmiList().equals(this.getCustomAmiList())) {
            return false;
        }
        if (other.getSupportedTierList() == null ^ this.getSupportedTierList() == null) {
            return false;
        }
        if (other.getSupportedTierList() != null && !other.getSupportedTierList().equals(this.getSupportedTierList())) {
            return false;
        }
        if (other.getSupportedAddonList() == null ^ this.getSupportedAddonList() == null) {
            return false;
        }
        return other.getSupportedAddonList() == null || other.getSupportedAddonList().equals(this.getSupportedAddonList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPlatformArn() == null ? 0 : this.getPlatformArn().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformOwner() == null ? 0 : this.getPlatformOwner().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformName() == null ? 0 : this.getPlatformName().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformVersion() == null ? 0 : this.getPlatformVersion().hashCode());
        hashCode = 31 * hashCode + (this.getSolutionStackName() == null ? 0 : this.getSolutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformStatus() == null ? 0 : this.getPlatformStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDateCreated() == null ? 0 : this.getDateCreated().hashCode());
        hashCode = 31 * hashCode + (this.getDateUpdated() == null ? 0 : this.getDateUpdated().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformCategory() == null ? 0 : this.getPlatformCategory().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getMaintainer() == null ? 0 : this.getMaintainer().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystemName() == null ? 0 : this.getOperatingSystemName().hashCode());
        hashCode = 31 * hashCode + (this.getOperatingSystemVersion() == null ? 0 : this.getOperatingSystemVersion().hashCode());
        hashCode = 31 * hashCode + (this.getProgrammingLanguages() == null ? 0 : this.getProgrammingLanguages().hashCode());
        hashCode = 31 * hashCode + (this.getFrameworks() == null ? 0 : this.getFrameworks().hashCode());
        hashCode = 31 * hashCode + (this.getCustomAmiList() == null ? 0 : this.getCustomAmiList().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedTierList() == null ? 0 : this.getSupportedTierList().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedAddonList() == null ? 0 : this.getSupportedAddonList().hashCode());
        return hashCode;
    }

    public PlatformDescription clone() {
        try {
            return (PlatformDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

