/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class MetricDatum
implements Serializable,
Cloneable {
    private String metricName;
    private SdkInternalList<Dimension> dimensions;
    private Date timestamp;
    private Double value;
    private StatisticSet statisticValues;
    private String unit;

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public MetricDatum withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public List<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new SdkInternalList();
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new SdkInternalList<Dimension>(dimensions);
    }

    public MetricDatum withDimensions(Dimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new SdkInternalList<Dimension>(dimensions.length));
        }
        for (Dimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public MetricDatum withDimensions(Collection<Dimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public MetricDatum withTimestamp(Date timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public Double getValue() {
        return this.value;
    }

    public MetricDatum withValue(Double value) {
        this.setValue(value);
        return this;
    }

    public void setStatisticValues(StatisticSet statisticValues) {
        this.statisticValues = statisticValues;
    }

    public StatisticSet getStatisticValues() {
        return this.statisticValues;
    }

    public MetricDatum withStatisticValues(StatisticSet statisticValues) {
        this.setStatisticValues(statisticValues);
        return this;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public MetricDatum withUnit(String unit) {
        this.setUnit(unit);
        return this;
    }

    @JsonIgnore
    public void setUnit(StandardUnit unit) {
        this.unit = unit.toString();
    }

    public MetricDatum withUnit(StandardUnit unit) {
        this.setUnit(unit);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getStatisticValues() != null) {
            sb.append("StatisticValues: ").append(this.getStatisticValues()).append(",");
        }
        if (this.getUnit() != null) {
            sb.append("Unit: ").append(this.getUnit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatum)) {
            return false;
        }
        MetricDatum other = (MetricDatum)obj;
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        if (other.getTimestamp() != null && !other.getTimestamp().equals(this.getTimestamp())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getStatisticValues() == null ^ this.getStatisticValues() == null) {
            return false;
        }
        if (other.getStatisticValues() != null && !other.getStatisticValues().equals(this.getStatisticValues())) {
            return false;
        }
        if (other.getUnit() == null ^ this.getUnit() == null) {
            return false;
        }
        return other.getUnit() == null || other.getUnit().equals(this.getUnit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getStatisticValues() == null ? 0 : this.getStatisticValues().hashCode());
        hashCode = 31 * hashCode + (this.getUnit() == null ? 0 : this.getUnit().hashCode());
        return hashCode;
    }

    public MetricDatum clone() {
        try {
            return (MetricDatum)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

