/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.SendCommandRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;

public class SendCommandRequestMarshaller
implements Marshaller<Request<SendCommandRequest>, SendCommandRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SendCommandRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SendCommandRequest> marshall(SendCommandRequest sendCommandRequest) {
        if (sendCommandRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendCommandRequest> request = new DefaultRequest<SendCommandRequest>(sendCommandRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.SendCommand");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, List<String>> parametersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList instanceIdsList = (SdkInternalList)sendCommandRequest.getInstanceIds();
            if (!instanceIdsList.isEmpty() || !instanceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceIds");
                jsonGenerator.writeStartArray();
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonGenerator.writeValue(instanceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (sendCommandRequest.getDocumentName() != null) {
                jsonGenerator.writeFieldName("DocumentName").writeValue(sendCommandRequest.getDocumentName());
            }
            if (sendCommandRequest.getDocumentHash() != null) {
                jsonGenerator.writeFieldName("DocumentHash").writeValue(sendCommandRequest.getDocumentHash());
            }
            if (sendCommandRequest.getDocumentHashType() != null) {
                jsonGenerator.writeFieldName("DocumentHashType").writeValue(sendCommandRequest.getDocumentHashType());
            }
            if (sendCommandRequest.getTimeoutSeconds() != null) {
                jsonGenerator.writeFieldName("TimeoutSeconds").writeValue(sendCommandRequest.getTimeoutSeconds());
            }
            if (sendCommandRequest.getComment() != null) {
                jsonGenerator.writeFieldName("Comment").writeValue(sendCommandRequest.getComment());
            }
            if ((parametersMap = sendCommandRequest.getParameters()) != null) {
                jsonGenerator.writeFieldName("Parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(parametersMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String parametersMapValueList : parametersMapValue.getValue()) {
                        if (parametersMapValueList == null) continue;
                        jsonGenerator.writeValue(parametersMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (sendCommandRequest.getOutputS3BucketName() != null) {
                jsonGenerator.writeFieldName("OutputS3BucketName").writeValue(sendCommandRequest.getOutputS3BucketName());
            }
            if (sendCommandRequest.getOutputS3KeyPrefix() != null) {
                jsonGenerator.writeFieldName("OutputS3KeyPrefix").writeValue(sendCommandRequest.getOutputS3KeyPrefix());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

