/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.Command;
import java.util.List;
import java.util.Map;

public class CommandJsonMarshaller {
    private static CommandJsonMarshaller instance;

    public void marshall(Command command, StructuredJsonGenerator jsonGenerator) {
        if (command == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList instanceIdsList;
            Map<String, List<String>> parametersMap;
            jsonGenerator.writeStartObject();
            if (command.getCommandId() != null) {
                jsonGenerator.writeFieldName("CommandId").writeValue(command.getCommandId());
            }
            if (command.getDocumentName() != null) {
                jsonGenerator.writeFieldName("DocumentName").writeValue(command.getDocumentName());
            }
            if (command.getComment() != null) {
                jsonGenerator.writeFieldName("Comment").writeValue(command.getComment());
            }
            if (command.getExpiresAfter() != null) {
                jsonGenerator.writeFieldName("ExpiresAfter").writeValue(command.getExpiresAfter());
            }
            if ((parametersMap = command.getParameters()) != null) {
                jsonGenerator.writeFieldName("Parameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(parametersMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String parametersMapValueList : parametersMapValue.getValue()) {
                        if (parametersMapValueList == null) continue;
                        jsonGenerator.writeValue(parametersMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (!(instanceIdsList = (SdkInternalList)command.getInstanceIds()).isEmpty() || !instanceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceIds");
                jsonGenerator.writeStartArray();
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonGenerator.writeValue(instanceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (command.getRequestedDateTime() != null) {
                jsonGenerator.writeFieldName("RequestedDateTime").writeValue(command.getRequestedDateTime());
            }
            if (command.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(command.getStatus());
            }
            if (command.getOutputS3BucketName() != null) {
                jsonGenerator.writeFieldName("OutputS3BucketName").writeValue(command.getOutputS3BucketName());
            }
            if (command.getOutputS3KeyPrefix() != null) {
                jsonGenerator.writeFieldName("OutputS3KeyPrefix").writeValue(command.getOutputS3KeyPrefix());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CommandJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CommandJsonMarshaller();
        }
        return instance;
    }
}

