/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53.model.AlarmIdentifier;
import com.amazonaws.services.route53.model.UpdateHealthCheckRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;

public class UpdateHealthCheckRequestMarshaller
implements Marshaller<Request<UpdateHealthCheckRequest>, UpdateHealthCheckRequest> {
    @Override
    public Request<UpdateHealthCheckRequest> marshall(UpdateHealthCheckRequest updateHealthCheckRequest) {
        if (updateHealthCheckRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateHealthCheckRequest> request = new DefaultRequest<UpdateHealthCheckRequest>(updateHealthCheckRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/healthcheck/{HealthCheckId}";
        uriResourcePath = uriResourcePath.replace("{HealthCheckId}", updateHealthCheckRequest.getHealthCheckId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(updateHealthCheckRequest.getHealthCheckId()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("UpdateHealthCheckRequest");
            if (updateHealthCheckRequest != null) {
                AlarmIdentifier alarmIdentifier;
                SdkInternalList updateHealthCheckRequestRegionsList;
                SdkInternalList updateHealthCheckRequestChildHealthChecksList;
                if (updateHealthCheckRequest.getHealthCheckVersion() != null) {
                    xmlWriter.startElement("HealthCheckVersion").value(updateHealthCheckRequest.getHealthCheckVersion()).endElement();
                }
                if (updateHealthCheckRequest.getIPAddress() != null) {
                    xmlWriter.startElement("IPAddress").value(updateHealthCheckRequest.getIPAddress()).endElement();
                }
                if (updateHealthCheckRequest.getPort() != null) {
                    xmlWriter.startElement("Port").value(updateHealthCheckRequest.getPort()).endElement();
                }
                if (updateHealthCheckRequest.getResourcePath() != null) {
                    xmlWriter.startElement("ResourcePath").value(updateHealthCheckRequest.getResourcePath()).endElement();
                }
                if (updateHealthCheckRequest.getFullyQualifiedDomainName() != null) {
                    xmlWriter.startElement("FullyQualifiedDomainName").value(updateHealthCheckRequest.getFullyQualifiedDomainName()).endElement();
                }
                if (updateHealthCheckRequest.getSearchString() != null) {
                    xmlWriter.startElement("SearchString").value(updateHealthCheckRequest.getSearchString()).endElement();
                }
                if (updateHealthCheckRequest.getFailureThreshold() != null) {
                    xmlWriter.startElement("FailureThreshold").value(updateHealthCheckRequest.getFailureThreshold()).endElement();
                }
                if (updateHealthCheckRequest.getInverted() != null) {
                    xmlWriter.startElement("Inverted").value(updateHealthCheckRequest.getInverted()).endElement();
                }
                if (updateHealthCheckRequest.getHealthThreshold() != null) {
                    xmlWriter.startElement("HealthThreshold").value(updateHealthCheckRequest.getHealthThreshold()).endElement();
                }
                if (!(updateHealthCheckRequestChildHealthChecksList = (SdkInternalList)updateHealthCheckRequest.getChildHealthChecks()).isEmpty() || !updateHealthCheckRequestChildHealthChecksList.isAutoConstruct()) {
                    xmlWriter.startElement("ChildHealthChecks");
                    for (String updateHealthCheckRequestChildHealthChecksListValue : updateHealthCheckRequestChildHealthChecksList) {
                        xmlWriter.startElement("ChildHealthCheck");
                        xmlWriter.value(updateHealthCheckRequestChildHealthChecksListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (updateHealthCheckRequest.getEnableSNI() != null) {
                    xmlWriter.startElement("EnableSNI").value(updateHealthCheckRequest.getEnableSNI()).endElement();
                }
                if (!(updateHealthCheckRequestRegionsList = (SdkInternalList)updateHealthCheckRequest.getRegions()).isEmpty() || !updateHealthCheckRequestRegionsList.isAutoConstruct()) {
                    xmlWriter.startElement("Regions");
                    for (String updateHealthCheckRequestRegionsListValue : updateHealthCheckRequestRegionsList) {
                        xmlWriter.startElement("Region");
                        xmlWriter.value(updateHealthCheckRequestRegionsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((alarmIdentifier = updateHealthCheckRequest.getAlarmIdentifier()) != null) {
                    xmlWriter.startElement("AlarmIdentifier");
                    if (alarmIdentifier.getRegion() != null) {
                        xmlWriter.startElement("Region").value(alarmIdentifier.getRegion()).endElement();
                    }
                    if (alarmIdentifier.getName() != null) {
                        xmlWriter.startElement("Name").value(alarmIdentifier.getName()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (updateHealthCheckRequest.getInsufficientDataHealthStatus() != null) {
                    xmlWriter.startElement("InsufficientDataHealthStatus").value(updateHealthCheckRequest.getInsufficientDataHealthStatus()).endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

