/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.TestMetricFilterRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class TestMetricFilterRequestMarshaller
implements Marshaller<Request<TestMetricFilterRequest>, TestMetricFilterRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public TestMetricFilterRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<TestMetricFilterRequest> marshall(TestMetricFilterRequest testMetricFilterRequest) {
        if (testMetricFilterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TestMetricFilterRequest> request = new DefaultRequest<TestMetricFilterRequest>(testMetricFilterRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.TestMetricFilter");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList logEventMessagesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (testMetricFilterRequest.getFilterPattern() != null) {
                jsonGenerator.writeFieldName("filterPattern").writeValue(testMetricFilterRequest.getFilterPattern());
            }
            if (!(logEventMessagesList = (SdkInternalList)testMetricFilterRequest.getLogEventMessages()).isEmpty() || !logEventMessagesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("logEventMessages");
                jsonGenerator.writeStartArray();
                for (String logEventMessagesListValue : logEventMessagesList) {
                    if (logEventMessagesListValue == null) continue;
                    jsonGenerator.writeValue(logEventMessagesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

