/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.ListJobsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListJobsRequestMarshaller
implements Marshaller<Request<ListJobsRequest>, ListJobsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public ListJobsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListJobsRequest> marshall(ListJobsRequest listJobsRequest) {
        if (listJobsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListJobsRequest> request = new DefaultRequest<ListJobsRequest>(listJobsRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs";
        uriResourcePath = uriResourcePath.replace("{accountId}", listJobsRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listJobsRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", listJobsRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listJobsRequest.getVaultName()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (listJobsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromString(listJobsRequest.getLimit()));
        }
        if (listJobsRequest.getMarker() != null) {
            request.addParameter("marker", StringUtils.fromString(listJobsRequest.getMarker()));
        }
        if (listJobsRequest.getStatuscode() != null) {
            request.addParameter("statuscode", StringUtils.fromString(listJobsRequest.getStatuscode()));
        }
        if (listJobsRequest.getCompleted() != null) {
            request.addParameter("completed", StringUtils.fromString(listJobsRequest.getCompleted()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

