/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.CompleteVaultLockRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class CompleteVaultLockRequestMarshaller
implements Marshaller<Request<CompleteVaultLockRequest>, CompleteVaultLockRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public CompleteVaultLockRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CompleteVaultLockRequest> marshall(CompleteVaultLockRequest completeVaultLockRequest) {
        if (completeVaultLockRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CompleteVaultLockRequest> request = new DefaultRequest<CompleteVaultLockRequest>(completeVaultLockRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/lock-policy/{lockId}";
        uriResourcePath = uriResourcePath.replace("{accountId}", completeVaultLockRequest.getAccountId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(completeVaultLockRequest.getAccountId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", completeVaultLockRequest.getVaultName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(completeVaultLockRequest.getVaultName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{lockId}", completeVaultLockRequest.getLockId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(completeVaultLockRequest.getLockId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

