/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.UpdateContainerAgentRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateContainerAgentRequestMarshaller
implements Marshaller<Request<UpdateContainerAgentRequest>, UpdateContainerAgentRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateContainerAgentRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateContainerAgentRequest> marshall(UpdateContainerAgentRequest updateContainerAgentRequest) {
        if (updateContainerAgentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateContainerAgentRequest> request = new DefaultRequest<UpdateContainerAgentRequest>(updateContainerAgentRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.UpdateContainerAgent");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateContainerAgentRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(updateContainerAgentRequest.getCluster());
            }
            if (updateContainerAgentRequest.getContainerInstance() != null) {
                jsonGenerator.writeFieldName("containerInstance").writeValue(updateContainerAgentRequest.getContainerInstance());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

