/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeConfigurationRecordersRequestMarshaller
implements Marshaller<Request<DescribeConfigurationRecordersRequest>, DescribeConfigurationRecordersRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeConfigurationRecordersRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeConfigurationRecordersRequest> marshall(DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) {
        if (describeConfigurationRecordersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeConfigurationRecordersRequest> request = new DefaultRequest<DescribeConfigurationRecordersRequest>(describeConfigurationRecordersRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.DescribeConfigurationRecorders");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList configurationRecorderNamesList = (SdkInternalList)describeConfigurationRecordersRequest.getConfigurationRecorderNames();
            if (!configurationRecorderNamesList.isEmpty() || !configurationRecorderNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ConfigurationRecorderNames");
                jsonGenerator.writeStartArray();
                for (String configurationRecorderNamesListValue : configurationRecorderNamesList) {
                    if (configurationRecorderNamesListValue == null) continue;
                    jsonGenerator.writeValue(configurationRecorderNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

