/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cognitosync.model.ListDatasetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListDatasetsRequestMarshaller
implements Marshaller<Request<ListDatasetsRequest>, ListDatasetsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public ListDatasetsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListDatasetsRequest> marshall(ListDatasetsRequest listDatasetsRequest) {
        if (listDatasetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDatasetsRequest> request = new DefaultRequest<ListDatasetsRequest>(listDatasetsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", listDatasetsRequest.getIdentityPoolId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listDatasetsRequest.getIdentityPoolId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{IdentityId}", listDatasetsRequest.getIdentityId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(listDatasetsRequest.getIdentityId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (listDatasetsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString(listDatasetsRequest.getNextToken()));
        }
        if (listDatasetsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger(listDatasetsRequest.getMaxResults()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

