/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.PatchOperation;
import com.amazonaws.services.apigateway.model.UpdateClientCertificateRequest;
import com.amazonaws.services.apigateway.model.transform.PatchOperationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdateClientCertificateRequestMarshaller
implements Marshaller<Request<UpdateClientCertificateRequest>, UpdateClientCertificateRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateClientCertificateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateClientCertificateRequest> marshall(UpdateClientCertificateRequest updateClientCertificateRequest) {
        if (updateClientCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateClientCertificateRequest> request = new DefaultRequest<UpdateClientCertificateRequest>(updateClientCertificateRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/clientcertificates/{clientcertificate_id}";
        uriResourcePath = uriResourcePath.replace("{clientcertificate_id}", updateClientCertificateRequest.getClientCertificateId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(updateClientCertificateRequest.getClientCertificateId()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<PatchOperation> patchOperationsList = updateClientCertificateRequest.getPatchOperations();
            if (patchOperationsList != null) {
                jsonGenerator.writeFieldName("patchOperations");
                jsonGenerator.writeStartArray();
                for (PatchOperation patchOperationsListValue : patchOperationsList) {
                    if (patchOperationsListValue == null) continue;
                    PatchOperationJsonMarshaller.getInstance().marshall(patchOperationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

