/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.waf.model.ListWebACLsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListWebACLsRequestMarshaller
implements Marshaller<Request<ListWebACLsRequest>, ListWebACLsRequest> {
    @Override
    public Request<ListWebACLsRequest> marshall(ListWebACLsRequest listWebACLsRequest) {
        if (listWebACLsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListWebACLsRequest> request = new DefaultRequest<ListWebACLsRequest>(listWebACLsRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.ListWebACLs");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (listWebACLsRequest.getNextMarker() != null) {
                jsonGenerator.writeFieldName("NextMarker").writeValue(listWebACLsRequest.getNextMarker());
            }
            if (listWebACLsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listWebACLsRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

