/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionConfiguration;
import com.amazonaws.services.simpleworkflow.model.transform.TaskListJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class WorkflowExecutionConfigurationJsonMarshaller {
    private static WorkflowExecutionConfigurationJsonMarshaller instance;

    public void marshall(WorkflowExecutionConfiguration workflowExecutionConfiguration, StructuredJsonGenerator jsonGenerator) {
        if (workflowExecutionConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (workflowExecutionConfiguration.getTaskStartToCloseTimeout() != null) {
                jsonGenerator.writeFieldName("taskStartToCloseTimeout").writeValue(workflowExecutionConfiguration.getTaskStartToCloseTimeout());
            }
            if (workflowExecutionConfiguration.getExecutionStartToCloseTimeout() != null) {
                jsonGenerator.writeFieldName("executionStartToCloseTimeout").writeValue(workflowExecutionConfiguration.getExecutionStartToCloseTimeout());
            }
            if (workflowExecutionConfiguration.getTaskList() != null) {
                jsonGenerator.writeFieldName("taskList");
                TaskListJsonMarshaller.getInstance().marshall(workflowExecutionConfiguration.getTaskList(), jsonGenerator);
            }
            if (workflowExecutionConfiguration.getTaskPriority() != null) {
                jsonGenerator.writeFieldName("taskPriority").writeValue(workflowExecutionConfiguration.getTaskPriority());
            }
            if (workflowExecutionConfiguration.getChildPolicy() != null) {
                jsonGenerator.writeFieldName("childPolicy").writeValue(workflowExecutionConfiguration.getChildPolicy());
            }
            if (workflowExecutionConfiguration.getLambdaRole() != null) {
                jsonGenerator.writeFieldName("lambdaRole").writeValue(workflowExecutionConfiguration.getLambdaRole());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkflowExecutionConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkflowExecutionConfigurationJsonMarshaller();
        }
        return instance;
    }
}

