/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class RespondActivityTaskCompletedRequestMarshaller
implements Marshaller<Request<RespondActivityTaskCompletedRequest>, RespondActivityTaskCompletedRequest> {
    @Override
    public Request<RespondActivityTaskCompletedRequest> marshall(RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest) {
        if (respondActivityTaskCompletedRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RespondActivityTaskCompletedRequest> request = new DefaultRequest<RespondActivityTaskCompletedRequest>(respondActivityTaskCompletedRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.RespondActivityTaskCompleted");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.0");
            jsonGenerator.writeStartObject();
            if (respondActivityTaskCompletedRequest.getTaskToken() != null) {
                jsonGenerator.writeFieldName("taskToken").writeValue(respondActivityTaskCompletedRequest.getTaskToken());
            }
            if (respondActivityTaskCompletedRequest.getResult() != null) {
                jsonGenerator.writeFieldName("result").writeValue(respondActivityTaskCompletedRequest.getResult());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

