/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetFunctionConfigurationRequestMarshaller
implements Marshaller<Request<GetFunctionConfigurationRequest>, GetFunctionConfigurationRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetFunctionConfigurationRequest> marshall(GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        if (getFunctionConfigurationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetFunctionConfigurationRequest> request = new DefaultRequest<GetFunctionConfigurationRequest>(getFunctionConfigurationRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/configuration";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", getFunctionConfigurationRequest.getFunctionName() != null ? StringUtils.fromString(getFunctionConfigurationRequest.getFunctionName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (getFunctionConfigurationRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString(getFunctionConfigurationRequest.getQualifier()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

