/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.ListPrincipalThingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListPrincipalThingsRequestMarshaller
implements Marshaller<Request<ListPrincipalThingsRequest>, ListPrincipalThingsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<ListPrincipalThingsRequest> marshall(ListPrincipalThingsRequest listPrincipalThingsRequest) {
        if (listPrincipalThingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPrincipalThingsRequest> request = new DefaultRequest<ListPrincipalThingsRequest>(listPrincipalThingsRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        if (listPrincipalThingsRequest.getPrincipal() != null) {
            request.addHeader("x-amzn-principal", StringUtils.fromString(listPrincipalThingsRequest.getPrincipal()));
        }
        String uriResourcePath = "/principals/things";
        request.setResourcePath(uriResourcePath);
        if (listPrincipalThingsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString(listPrincipalThingsRequest.getNextToken()));
        }
        if (listPrincipalThingsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger(listPrincipalThingsRequest.getMaxResults()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

