/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PutMethodResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class PutMethodResponseRequestMarshaller
implements Marshaller<Request<PutMethodResponseRequest>, PutMethodResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<PutMethodResponseRequest> marshall(PutMethodResponseRequest putMethodResponseRequest) {
        if (putMethodResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutMethodResponseRequest> request = new DefaultRequest<PutMethodResponseRequest>(putMethodResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putMethodResponseRequest.getRestApiId() != null ? StringUtils.fromString(putMethodResponseRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{resource_id}", putMethodResponseRequest.getResourceId() != null ? StringUtils.fromString(putMethodResponseRequest.getResourceId()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{http_method}", putMethodResponseRequest.getHttpMethod() != null ? StringUtils.fromString(putMethodResponseRequest.getHttpMethod()) : DEFAULT_CONTENT_TYPE);
        uriResourcePath = uriResourcePath.replace("{status_code}", putMethodResponseRequest.getStatusCode() != null ? StringUtils.fromString(putMethodResponseRequest.getStatusCode()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> responseModelsMap;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            Map<String, Boolean> responseParametersMap = putMethodResponseRequest.getResponseParameters();
            if (responseParametersMap != null) {
                jsonGenerator.writeFieldName("responseParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Boolean> responseParametersMapValue : responseParametersMap.entrySet()) {
                    if (responseParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(responseParametersMapValue.getKey());
                    jsonGenerator.writeValue(responseParametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((responseModelsMap = putMethodResponseRequest.getResponseModels()) != null) {
                jsonGenerator.writeFieldName("responseModels");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> responseModelsMapValue : responseModelsMap.entrySet()) {
                    if (responseModelsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(responseModelsMapValue.getKey());
                    jsonGenerator.writeValue(responseModelsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

