/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.support.model.Attachment;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class AttachmentJsonMarshaller {
    private static AttachmentJsonMarshaller instance;

    public void marshall(Attachment attachment, StructuredJsonGenerator jsonGenerator) {
        if (attachment == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (attachment.getFileName() != null) {
                jsonGenerator.writeFieldName("fileName").writeValue(attachment.getFileName());
            }
            if (attachment.getData() != null) {
                jsonGenerator.writeFieldName("data").writeValue(attachment.getData());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttachmentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttachmentJsonMarshaller();
        }
        return instance;
    }
}

