/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecr.model.CompleteLayerUploadRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CompleteLayerUploadRequestMarshaller
implements Marshaller<Request<CompleteLayerUploadRequest>, CompleteLayerUploadRequest> {
    @Override
    public Request<CompleteLayerUploadRequest> marshall(CompleteLayerUploadRequest completeLayerUploadRequest) {
        if (completeLayerUploadRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CompleteLayerUploadRequest> request = new DefaultRequest<CompleteLayerUploadRequest>(completeLayerUploadRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.CompleteLayerUpload");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> layerDigestsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (completeLayerUploadRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(completeLayerUploadRequest.getRegistryId());
            }
            if (completeLayerUploadRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(completeLayerUploadRequest.getRepositoryName());
            }
            if (completeLayerUploadRequest.getUploadId() != null) {
                jsonGenerator.writeFieldName("uploadId").writeValue(completeLayerUploadRequest.getUploadId());
            }
            if ((layerDigestsList = completeLayerUploadRequest.getLayerDigests()) != null) {
                jsonGenerator.writeFieldName("layerDigests");
                jsonGenerator.writeStartArray();
                for (String layerDigestsListValue : layerDigestsList) {
                    if (layerDigestsListValue == null) continue;
                    jsonGenerator.writeValue(layerDigestsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

