/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.Shard;
import com.amazonaws.services.dynamodbv2.model.transform.SequenceNumberRangeJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ShardJsonMarshaller {
    private static ShardJsonMarshaller instance;

    public void marshall(Shard shard, StructuredJsonGenerator jsonGenerator) {
        if (shard == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (shard.getShardId() != null) {
                jsonGenerator.writeFieldName("ShardId").writeValue(shard.getShardId());
            }
            if (shard.getSequenceNumberRange() != null) {
                jsonGenerator.writeFieldName("SequenceNumberRange");
                SequenceNumberRangeJsonMarshaller.getInstance().marshall(shard.getSequenceNumberRange(), jsonGenerator);
            }
            if (shard.getParentShardId() != null) {
                jsonGenerator.writeFieldName("ParentShardId").writeValue(shard.getParentShardId());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ShardJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ShardJsonMarshaller();
        }
        return instance;
    }
}

