/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.waf.model.CreateRuleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class CreateRuleRequestMarshaller
implements Marshaller<Request<CreateRuleRequest>, CreateRuleRequest> {
    @Override
    public Request<CreateRuleRequest> marshall(CreateRuleRequest createRuleRequest) {
        if (createRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateRuleRequest> request = new DefaultRequest<CreateRuleRequest>(createRuleRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.CreateRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (createRuleRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createRuleRequest.getName());
            }
            if (createRuleRequest.getMetricName() != null) {
                jsonGenerator.writeFieldName("MetricName").writeValue(createRuleRequest.getMetricName());
            }
            if (createRuleRequest.getChangeToken() != null) {
                jsonGenerator.writeFieldName("ChangeToken").writeValue(createRuleRequest.getChangeToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

