/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.DBClusterMember;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DBClusterMemberStaxUnmarshaller
implements Unmarshaller<DBClusterMember, StaxUnmarshallerContext> {
    private static DBClusterMemberStaxUnmarshaller instance;

    @Override
    public DBClusterMember unmarshall(StaxUnmarshallerContext context) throws Exception {
        DBClusterMember dBClusterMember = new DBClusterMember();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return dBClusterMember;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DBInstanceIdentifier", targetDepth)) {
                    dBClusterMember.setDBInstanceIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsClusterWriter", targetDepth)) {
                    dBClusterMember.setIsClusterWriter(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBClusterParameterGroupStatus", targetDepth)) {
                    dBClusterMember.setDBClusterParameterGroupStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PromotionTier", targetDepth)) continue;
                dBClusterMember.setPromotionTier(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return dBClusterMember;
    }

    public static DBClusterMemberStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DBClusterMemberStaxUnmarshaller();
        }
        return instance;
    }
}

