/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.Record;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class RecordJsonMarshaller {
    private static RecordJsonMarshaller instance;

    public void marshall(Record record, StructuredJsonGenerator jsonGenerator) {
        if (record == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (record.getData() != null) {
                jsonGenerator.writeFieldName("Data").writeValue(record.getData());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecordJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecordJsonMarshaller();
        }
        return instance;
    }
}

