/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.Deployment;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class DeploymentJsonMarshaller {
    private static DeploymentJsonMarshaller instance;

    public void marshall(Deployment deployment, StructuredJsonGenerator jsonGenerator) {
        if (deployment == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (deployment.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(deployment.getId());
            }
            if (deployment.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(deployment.getStatus());
            }
            if (deployment.getTaskDefinition() != null) {
                jsonGenerator.writeFieldName("taskDefinition").writeValue(deployment.getTaskDefinition());
            }
            if (deployment.getDesiredCount() != null) {
                jsonGenerator.writeFieldName("desiredCount").writeValue(deployment.getDesiredCount());
            }
            if (deployment.getPendingCount() != null) {
                jsonGenerator.writeFieldName("pendingCount").writeValue(deployment.getPendingCount());
            }
            if (deployment.getRunningCount() != null) {
                jsonGenerator.writeFieldName("runningCount").writeValue(deployment.getRunningCount());
            }
            if (deployment.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(deployment.getCreatedAt());
            }
            if (deployment.getUpdatedAt() != null) {
                jsonGenerator.writeFieldName("updatedAt").writeValue(deployment.getUpdatedAt());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentJsonMarshaller();
        }
        return instance;
    }
}

