/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.ValidationError;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ValidationErrorJsonMarshaller {
    private static ValidationErrorJsonMarshaller instance;

    public void marshall(ValidationError validationError, StructuredJsonGenerator jsonGenerator) {
        if (validationError == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList errorsList;
            jsonGenerator.writeStartObject();
            if (validationError.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(validationError.getId());
            }
            if (!(errorsList = (SdkInternalList)validationError.getErrors()).isEmpty() || !errorsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("errors");
                jsonGenerator.writeStartArray();
                for (String errorsListValue : errorsList) {
                    if (errorsListValue == null) continue;
                    jsonGenerator.writeValue(errorsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ValidationErrorJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ValidationErrorJsonMarshaller();
        }
        return instance;
    }
}

