/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.DeleteApiKeyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteApiKeyRequestMarshaller
implements Marshaller<Request<DeleteApiKeyRequest>, DeleteApiKeyRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DeleteApiKeyRequest> marshall(DeleteApiKeyRequest deleteApiKeyRequest) {
        if (deleteApiKeyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteApiKeyRequest> request = new DefaultRequest<DeleteApiKeyRequest>(deleteApiKeyRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/apikeys/{api_Key}";
        uriResourcePath = uriResourcePath.replace("{api_Key}", deleteApiKeyRequest.getApiKey() != null ? StringUtils.fromString(deleteApiKeyRequest.getApiKey()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

