/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.ScheduledInstanceRecurrenceRequest;
import com.amazonaws.services.ec2.model.SlotDateTimeRangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeScheduledInstanceAvailabilityRequestMarshaller
implements Marshaller<Request<DescribeScheduledInstanceAvailabilityRequest>, DescribeScheduledInstanceAvailabilityRequest> {
    @Override
    public Request<DescribeScheduledInstanceAvailabilityRequest> marshall(DescribeScheduledInstanceAvailabilityRequest describeScheduledInstanceAvailabilityRequest) {
        SdkInternalList filtersList;
        SlotDateTimeRangeRequest firstSlotStartTimeRange;
        if (describeScheduledInstanceAvailabilityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeScheduledInstanceAvailabilityRequest> request = new DefaultRequest<DescribeScheduledInstanceAvailabilityRequest>(describeScheduledInstanceAvailabilityRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeScheduledInstanceAvailability");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        ScheduledInstanceRecurrenceRequest recurrence = describeScheduledInstanceAvailabilityRequest.getRecurrence();
        if (recurrence != null) {
            SdkInternalList occurrenceDaysList;
            if (recurrence.getFrequency() != null) {
                request.addParameter("Recurrence.Frequency", StringUtils.fromString(recurrence.getFrequency()));
            }
            if (recurrence.getInterval() != null) {
                request.addParameter("Recurrence.Interval", StringUtils.fromInteger(recurrence.getInterval()));
            }
            if (!(occurrenceDaysList = (SdkInternalList)recurrence.getOccurrenceDays()).isEmpty() || !occurrenceDaysList.isAutoConstruct()) {
                int occurrenceDaysListIndex = 1;
                for (Integer occurrenceDaysListValue : occurrenceDaysList) {
                    if (occurrenceDaysListValue != null) {
                        request.addParameter("Recurrence.OccurrenceDay." + occurrenceDaysListIndex, StringUtils.fromInteger(occurrenceDaysListValue));
                    }
                    ++occurrenceDaysListIndex;
                }
            }
            if (recurrence.getOccurrenceRelativeToEnd() != null) {
                request.addParameter("Recurrence.OccurrenceRelativeToEnd", StringUtils.fromBoolean(recurrence.getOccurrenceRelativeToEnd()));
            }
            if (recurrence.getOccurrenceUnit() != null) {
                request.addParameter("Recurrence.OccurrenceUnit", StringUtils.fromString(recurrence.getOccurrenceUnit()));
            }
        }
        if ((firstSlotStartTimeRange = describeScheduledInstanceAvailabilityRequest.getFirstSlotStartTimeRange()) != null) {
            if (firstSlotStartTimeRange.getEarliestTime() != null) {
                request.addParameter("FirstSlotStartTimeRange.EarliestTime", StringUtils.fromDate(firstSlotStartTimeRange.getEarliestTime()));
            }
            if (firstSlotStartTimeRange.getLatestTime() != null) {
                request.addParameter("FirstSlotStartTimeRange.LatestTime", StringUtils.fromDate(firstSlotStartTimeRange.getLatestTime()));
            }
        }
        if (describeScheduledInstanceAvailabilityRequest.getMinSlotDurationInHours() != null) {
            request.addParameter("MinSlotDurationInHours", StringUtils.fromInteger(describeScheduledInstanceAvailabilityRequest.getMinSlotDurationInHours()));
        }
        if (describeScheduledInstanceAvailabilityRequest.getMaxSlotDurationInHours() != null) {
            request.addParameter("MaxSlotDurationInHours", StringUtils.fromInteger(describeScheduledInstanceAvailabilityRequest.getMaxSlotDurationInHours()));
        }
        if (describeScheduledInstanceAvailabilityRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeScheduledInstanceAvailabilityRequest.getNextToken()));
        }
        if (describeScheduledInstanceAvailabilityRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeScheduledInstanceAvailabilityRequest.getMaxResults()));
        }
        if (!(filtersList = (SdkInternalList)describeScheduledInstanceAvailabilityRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

