/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.config.model.ConfigRule;
import com.amazonaws.services.config.model.transform.ScopeJsonMarshaller;
import com.amazonaws.services.config.model.transform.SourceJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class ConfigRuleJsonMarshaller {
    private static ConfigRuleJsonMarshaller instance;

    public void marshall(ConfigRule configRule, StructuredJsonGenerator jsonGenerator) {
        if (configRule == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (configRule.getConfigRuleName() != null) {
                jsonGenerator.writeFieldName("ConfigRuleName").writeValue(configRule.getConfigRuleName());
            }
            if (configRule.getConfigRuleArn() != null) {
                jsonGenerator.writeFieldName("ConfigRuleArn").writeValue(configRule.getConfigRuleArn());
            }
            if (configRule.getConfigRuleId() != null) {
                jsonGenerator.writeFieldName("ConfigRuleId").writeValue(configRule.getConfigRuleId());
            }
            if (configRule.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(configRule.getDescription());
            }
            if (configRule.getScope() != null) {
                jsonGenerator.writeFieldName("Scope");
                ScopeJsonMarshaller.getInstance().marshall(configRule.getScope(), jsonGenerator);
            }
            if (configRule.getSource() != null) {
                jsonGenerator.writeFieldName("Source");
                SourceJsonMarshaller.getInstance().marshall(configRule.getSource(), jsonGenerator);
            }
            if (configRule.getInputParameters() != null) {
                jsonGenerator.writeFieldName("InputParameters").writeValue(configRule.getInputParameters());
            }
            if (configRule.getMaximumExecutionFrequency() != null) {
                jsonGenerator.writeFieldName("MaximumExecutionFrequency").writeValue(configRule.getMaximumExecutionFrequency());
            }
            if (configRule.getConfigRuleState() != null) {
                jsonGenerator.writeFieldName("ConfigRuleState").writeValue(configRule.getConfigRuleState());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConfigRuleJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConfigRuleJsonMarshaller();
        }
        return instance;
    }
}

