/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.BatchGetApplicationRevisionsRequest;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import com.amazonaws.services.codedeploy.model.transform.RevisionLocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class BatchGetApplicationRevisionsRequestMarshaller
implements Marshaller<Request<BatchGetApplicationRevisionsRequest>, BatchGetApplicationRevisionsRequest> {
    @Override
    public Request<BatchGetApplicationRevisionsRequest> marshall(BatchGetApplicationRevisionsRequest batchGetApplicationRevisionsRequest) {
        if (batchGetApplicationRevisionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetApplicationRevisionsRequest> request = new DefaultRequest<BatchGetApplicationRevisionsRequest>(batchGetApplicationRevisionsRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.BatchGetApplicationRevisions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList revisionsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (batchGetApplicationRevisionsRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(batchGetApplicationRevisionsRequest.getApplicationName());
            }
            if (!(revisionsList = (SdkInternalList)batchGetApplicationRevisionsRequest.getRevisions()).isEmpty() || !revisionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("revisions");
                jsonGenerator.writeStartArray();
                for (RevisionLocation revisionsListValue : revisionsList) {
                    if (revisionsListValue == null) continue;
                    RevisionLocationJsonMarshaller.getInstance().marshall(revisionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

