/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetApiKeyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetApiKeyRequestMarshaller
implements Marshaller<Request<GetApiKeyRequest>, GetApiKeyRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetApiKeyRequest> marshall(GetApiKeyRequest getApiKeyRequest) {
        if (getApiKeyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetApiKeyRequest> request = new DefaultRequest<GetApiKeyRequest>(getApiKeyRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/apikeys/{api_Key}";
        uriResourcePath = uriResourcePath.replace("{api_Key}", getApiKeyRequest.getApiKey() != null ? StringUtils.fromString(getApiKeyRequest.getApiKey()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

