/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kinesis.model.EnableEnhancedMonitoringRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class EnableEnhancedMonitoringRequestMarshaller
implements Marshaller<Request<EnableEnhancedMonitoringRequest>, EnableEnhancedMonitoringRequest> {
    @Override
    public Request<EnableEnhancedMonitoringRequest> marshall(EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) {
        if (enableEnhancedMonitoringRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableEnhancedMonitoringRequest> request = new DefaultRequest<EnableEnhancedMonitoringRequest>(enableEnhancedMonitoringRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.EnableEnhancedMonitoring");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList shardLevelMetricsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (enableEnhancedMonitoringRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(enableEnhancedMonitoringRequest.getStreamName());
            }
            if (!(shardLevelMetricsList = (SdkInternalList)enableEnhancedMonitoringRequest.getShardLevelMetrics()).isEmpty() || !shardLevelMetricsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ShardLevelMetrics");
                jsonGenerator.writeStartArray();
                for (String shardLevelMetricsListValue : shardLevelMetricsList) {
                    if (shardLevelMetricsListValue == null) continue;
                    jsonGenerator.writeValue(shardLevelMetricsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

