/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.ListFindingsRequest;
import com.amazonaws.services.inspector.model.transform.FindingFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class ListFindingsRequestMarshaller
implements Marshaller<Request<ListFindingsRequest>, ListFindingsRequest> {
    @Override
    public Request<ListFindingsRequest> marshall(ListFindingsRequest listFindingsRequest) {
        if (listFindingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListFindingsRequest> request = new DefaultRequest<ListFindingsRequest>(listFindingsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListFindings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            List<String> assessmentRunArnsList = listFindingsRequest.getAssessmentRunArns();
            if (assessmentRunArnsList != null) {
                jsonGenerator.writeFieldName("assessmentRunArns");
                jsonGenerator.writeStartArray();
                for (String assessmentRunArnsListValue : assessmentRunArnsList) {
                    if (assessmentRunArnsListValue == null) continue;
                    jsonGenerator.writeValue(assessmentRunArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listFindingsRequest.getFilter() != null) {
                jsonGenerator.writeFieldName("filter");
                FindingFilterJsonMarshaller.getInstance().marshall(listFindingsRequest.getFilter(), jsonGenerator);
            }
            if (listFindingsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listFindingsRequest.getNextToken());
            }
            if (listFindingsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listFindingsRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

