/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListTaskDefinitionsRequestMarshaller
implements Marshaller<Request<ListTaskDefinitionsRequest>, ListTaskDefinitionsRequest> {
    @Override
    public Request<ListTaskDefinitionsRequest> marshall(ListTaskDefinitionsRequest listTaskDefinitionsRequest) {
        if (listTaskDefinitionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTaskDefinitionsRequest> request = new DefaultRequest<ListTaskDefinitionsRequest>(listTaskDefinitionsRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.ListTaskDefinitions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (listTaskDefinitionsRequest.getFamilyPrefix() != null) {
                jsonGenerator.writeFieldName("familyPrefix").writeValue(listTaskDefinitionsRequest.getFamilyPrefix());
            }
            if (listTaskDefinitionsRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(listTaskDefinitionsRequest.getStatus());
            }
            if (listTaskDefinitionsRequest.getSort() != null) {
                jsonGenerator.writeFieldName("sort").writeValue(listTaskDefinitionsRequest.getSort());
            }
            if (listTaskDefinitionsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listTaskDefinitionsRequest.getNextToken());
            }
            if (listTaskDefinitionsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listTaskDefinitionsRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

